package com.huigou.uasp.form.repository;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.huigou.uasp.form.domain.model.FormAttribute;
import com.huigou.uasp.form.domain.model.FormSearchSql;


public interface FormAttributeRepository extends JpaRepository<FormAttribute, String>{

	List<FormAttribute> findByFormId(String formId);
	
	@Query("from FormAttribute s where  s.formId=?1 and s.tableName=?2 order by s.sequence ")
    List <FormAttribute> findByFormIdAndTable(String formId,String tableName);
	 
	@Query("from FormAttribute s where  s.formId=?1 and s.tableType=?2 ") 
    List <FormAttribute> findByFormIdAndType(String formId,int tableType);

	@Query("from FormAttribute s where  s.formId=?1 and s.tableName=?2 and s.fieldTag=?3 ")
	List <FormAttribute> findByFormIdAndTableFieldTag(String formId,String tableName,String fieldTag);


	@Modifying  
	@Query("delete from FormAttribute u WHERE u.formId=?1 ")    
    void deleteFormAttribute(String formId); 
	
	@Modifying  
	@Query("delete from FormAttribute u WHERE u.formId=?1 and u.tableName=?2 ")    
    void deleteFormAttributeByFormIdAndTableName(String formId,String tableName); 
	
	 @Modifying
	@Query("UPDATE FormAttribute u SET u.displayListing = ?1 WHERE u.formId = ?2")
	void updateDisplayListing(Integer displayListing, String  formId);
	 
	 @Modifying
	@Query("UPDATE FormAttribute u SET u.searchField = ?1 WHERE u.formId = ?2")
	void updateSearchField(Integer searchField,String  formId);
}
