package com.huigou.uasp.form.domain.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Entity
@EntityListeners({CreatorAndModifierListener.class})
public class PropertyDefines extends AbstractEntity implements Comparable<PropertyDefines>{
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 * 字段名
	 */
	@Column(name = "column_name")
	private String columnName;
	
	/**
	 * 
	 * 字段类型
	 */
	@Column(name = "data_type")
	private String dataType;
	/**
	 * 
	 * 长度
	 */
	@Column(name = "data_length")
	private String dataLength;
	/**
	 * 
	 * 注释
	 */
	@Column(name = "comments")
	private String comments;
	/**
	 * 
	 * 列序好
	 */
	@Column(name = "column_id")
	private String columnId;
	/**
	 * 
	 * 是否必填
	 */
	@Column(name = "nullable")
	private String nullable;
		
	private String yesorno;
	
	private String listdisplayField;
	
	private String listdisplayType;
	
	private String listdisplayFieldName;
	
	private String xmControlType;
	
	private String fieldTag;
	
	private String validatorType;
	
	private String dataSourceType;
	
	private String dataSource;
	
	private String listdisplaySearchField;

	private String sequence;
	

	@Override
	  public int compareTo(PropertyDefines s) {

	         if(Integer.parseInt(!"".equals(this.sequence)?this.sequence:"0") >= Integer.parseInt((!"".equals(s.getSequence())?s.getSequence():"0"))){
	              return 1;
	          }
	          return -1;
	    
	  }
	
	
}
