package com.huigou.uasp.form.domain.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.Creator;
import com.huigou.data.domain.model.TreeEntity;
import com.huigou.data.domain.model.Modifier;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Entity
@Table(name = "SAF_FORM_TREE")
@EntityListeners({CreatorAndModifierListener.class})
public class FormTree extends TreeEntity{
	private static final long serialVersionUID = 1L;
	/**
	 * 1模板 2 表单 3 功能)
	 */
	@Column(name = "NODE_TYPE",length = 50)
	private String parentNodeType;
	

	
	@Transient
	private String nodeType;
	
	@Transient
	private String oldId;
	
	
	/**
	 * 创建人信息
	 */
	@Embedded
	private Creator creator;
	
	/**
	 * 最后修改人信息
	 */
	@Embedded
	private Modifier modifier;
	
	
	

}
