package com.huigou.uasp.form.domain.model;


import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Entity
@Table(name = "SAF_FORM_SEARCH_SQL")
public class FormSearchSql extends AbstractEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 表名
	 */
	@Column(name = "table_name", length = 128)
	private String tableName;


	/**
	 * xml中搜索名称
	 */
	@Column(name = "search_name", length = 32)
	private String searchName;

	/**
	 * xml中搜索名称描述
	 */
	@Column(name = "search_desc", length = 100)
	private String searchDesc;


	/**
	 * easy_search的xml文件名称
	 */
	@Column(name = "searchbox_type", length = 32)
	private String searchboxType;

	/**
	 * 目标业务字段
	 */
	@Column(name = "target_field", length = 32)
	private String targetField;


	/**
	 * 显示字段名称（多个以逗号分隔）
	 */
	@Column(name = "field_names", length = 1000)
	private String fieldNames;


	/**
	 * 显示字段code（多个以逗号分隔）
	 */
	@Column(name = "field_codes", length = 1000)
	private String fieldCodes;

	/**
	 * 显示字段类型
	 */
	@Column(name = "field_types", length = 1000)
	private String fieldTypes;


	/**
	 * 显示字段宽度
	 */
	@Column(name = "field_widths", length = 1000)
	private String fieldWidths;



	/**
	 * 列表框搜索条件字段（多个以逗号分隔）
	 */
	@Column(name = "condi_columns", length = 1000)
	private String condiColumns;



	/**
	 * 列表框搜索条件名称
	 */
	@Column(name = "condi_names", length = 1000)
	private String condiNames;



	/**
	 * 列表框搜索条件字段类型
	 */
	@Column(name = "condi_types", length = 1000)
	private String condiTypes;



	/**
	 * 列表框搜索条件匹配类型
	 */
	@Column(name = "condi_symbols", length = 1000)
	private String condiSymbols;


	/**
	 * 搜索条件表别名
	 */
	@Column(name = "condi_alias", length = 1000)
	private String condiAlias;



	/**
	 * 排序字段
	 */
	@Column(name = "orderby", length = 1000)
	private String orderby;



	/**
	 * 查询的sql语句
	 */
	@Column(name = "search_sql", length = 1000)
	private String searchSql;


	/**
	 * 页面接收字段
	 */
	@Column(name = "back_fields", length = 1000)
	private String backFields;


	/*
	 * SQL中指定参数名称（以冒号开头的）
	 */
	@Column(name = "param_fields", length = 1000)
	private String paramFields;



	/*
	 * SQL中指定参数的对应来源字段
	 */
	@Column(name = "param_source_fields", length = 1000)
	private String paramSourceFields;


	  /**
     * 创建时间
     */
    @Column(name = "created_date", length = 20)
    private Date  createdDate;



	/*
	 * SQL中指定参数的对应来源表
	 */
	@Column(name = "param_source_tables", length = 1000)
	private String paramSourceTables;
	
	
	@Column(name = "form_no", length = 100)
	private String formNo;

	@Column(name = "content", length = 3000)
	private String content;


	
	
}
