package com.huigou.uasp.form.domain.model;

import java.util.Date;
import java.lang.Double;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Getter
@Setter
@Entity
@Table(name = "SAF_FORM_PARAMETER")
@EntityListeners({CreatorAndModifierListener.class})
public class FormParameter extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    /**
     * FormId
     */
    @Column(name = "FORM_NO", length = 100)
    private String formNo;

   
    /**
     * 参数类型 参数类型:1、表单提示 2、检索SQL 3、校验函数 4、存储过程 5、文件附件
     */
    @Column(name = "parm_type", length = 10)
    private Integer parmType;

    
    /**
     * 参数Name 参数说明/附件标题
     */
    @Column(name = "parm_name", length = 100)
    private String parmName;
    

    /**
     * 参数Code 参数编码/函数名称/过程名称/附件CODE
     */
    @Column(name = "parm_code", length = 100)
    private String parmCode;
    
    
    /**
     * 参数Code  参数值/附件ID
     */
    @Column(name = "parm_vals", length = 3000)
    private String parmVals;

	//文件附件显示顺序
	@Column(name="display_nums",length=10)
	private Integer displayNums;

     /**
     * 状态1启用、停用0
     */
    @Column(name = "status", length =10)
    private Integer status;

    /**
     * 备注
     */
    @Column(name = "remark", length = 1000)
    private String remark;


}
