package com.huigou.uasp.form.domain.model;

import java.util.Date;
import java.lang.Double;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@Getter
@Setter
@Entity
@Table(name = "SAF_FORM_BUTTONS")
@EntityListeners({CreatorAndModifierListener.class})
public class FormButtons extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    /**
     * FormId
     */
    @Column(name = "form_id", length = 32)
    private String formId;

   
    /**
     * 按钮名称
     */
    @Column(name = "button_name", length = 100)
    private String buttonName;

    /**
     * 按钮方法名称
     */
    @Column(name = "button_method_name", length = 100)
    private String buttonMethodName;
    
    
    /**
     * 按钮方法内容 
     */
    @Column(name = "button_method_content", length = 1000)
    private String buttonMethodContent;
    
    
    @Column(name = "button_type", length = 10)
    private Integer buttonType;
    
    
    @Column(name = "button_key", length = 100)
    private String buttonKey;
    
    @Column(name = "sequence", length = 10)
    private Integer sequence;
    
    
    @Column(name = "remark", length = 1000)
    private String remark;

    /**
     * 页签名称
     */
    @Column(name = "tab_label", length = 100)
    private String  tabLabel;


    /**
     * 数据模型名称
     */
    @Column(name = "table_name", length = 100)
    private String tableName;

    /**
     * 存储过程名称
     */
    @Column(name = "procedure_name", length = 100)
    private String procedureName;

    /**
     * 状态1启用、停用0
     */
    @Column(name = "status", length = 22)
    private Integer status;

    @Transient
    private String modelName;
	
}
