package com.huigou.uasp.form.controller;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.configuration.application.CommonTreeApplication;
import com.huigou.uasp.bmp.configuration.domain.model.CommonTree;
import com.huigou.uasp.bmp.configuration.repository.CommonTreeRepository;
import com.huigou.uasp.bmp.opm.proxy.AccessApplicationProxy;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.DataPermissionApplication;
import com.huigou.uasp.form.application.FormsDesignApplication;
import com.huigou.uasp.form.application.PowerConfigApplication;
import com.huigou.uasp.form.domain.model.FormAttribute;
import com.huigou.uasp.form.domain.model.FormButtons;
import com.huigou.uasp.form.domain.model.FormTables;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.domain.query.FormParameterQueryRequest;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.repository.FormAttributeRepository;
import com.huigou.uasp.form.repository.FormButtonsRepository;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.uasp.util.Constant;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.*;

@Controller
@ControllerMapping("powerConfig")
public class PowerConfigController extends CommonController {

    @Autowired
    private FormTablesRepository formTablesRepository;

    @Autowired
    private FormButtonsRepository formButtonsRepository;

    @Autowired
    private  FormsDesignApplication  formsDesignApplication;
    @Autowired
    private  PowerConfigApplication powerConfigApplication;

    protected String getPagePath(){
        return "/formdesign/forms/";
    }

    //进入自定义按钮页面 表单按钮配置
    public String  loadCustomButtonDetail(){
        SDO sdo = this.getSDO();
        SafFormsQueryRequest queryRequest = sdo.toQueryRequest(SafFormsQueryRequest.class);
        FormButtons formButtons=new FormButtons();

        if ("3".equals(sdo.getString("type"))&&StringUtil.isNotBlank(sdo.getString("id"))) {
            List<Map<String, Object>> list = powerConfigApplication.queryFormButtonTableName(queryRequest);
            if  (list.size()>0) {
                Map<String, Object> map = list.get(0);

                formButtons.setId(map.get("id").toString());
                formButtons.setFormId(map.get("formId").toString());
                formButtons.setButtonName(map.get("buttonName").toString());
                formButtons.setButtonMethodName(map.get("buttonMethodName").toString());
                formButtons.setButtonKey(map.get("buttonKey").toString());
                formButtons.setModelName(map.get("name").toString());
                formButtons.setTableName(map.get("tableName").toString());
                formButtons.setButtonMethodContent(map.get("buttonMethodContent").toString());
                formButtons.setButtonType(3);
            }
            Map <String, Object> map=new LinkedHashMap();
            map.put("addRow","新增行");
            map.put("saveRow","保存行");
            map.put("deleteRow","删除行");
            this.putAttribute("buttonMethodList",map);

            queryRequest.setId(sdo.getString("formId"));
            List<Map<String, Object>> modelList=powerConfigApplication.querySelectedTableListByFormId(queryRequest);
            Map <String, Object> mapModel=new LinkedHashMap();
            for (Map model :modelList){
                if ("2".equals(model.get("tableType").toString())){
                    mapModel.put(model.get("tableName").toString(), model.get("name").toString());
                }
            }

            this.putAttribute("modelNameList",mapModel);
        } else {  //默认
            List<Map<String, Object>> list = powerConfigApplication.queryFormButtonTableName(queryRequest);
            if  (list.size()>0) {
                Map<String, Object> map = list.get(0);

                formButtons.setId(map.get("id").toString());
                formButtons.setFormId(map.get("formId").toString());
                formButtons.setButtonName(map.get("buttonName").toString());
                formButtons.setButtonMethodName(map.get("buttonMethodName").toString());
                formButtons.setButtonKey(map.get("buttonKey").toString());
                formButtons.setModelName(map.get("name").toString());
                formButtons.setTableName(map.get("tableName").toString());
                formButtons.setProcedureName(map.get("procedure_name") != null ? map.get("procedure_name").toString() : "");
                formButtons.setButtonMethodContent(map.get("buttonMethodContent").toString());
            }
            formButtons.setButtonType(2);
            formButtons.setFormId(sdo.getString("formId"));
        }
        List<Map<String, Object>> procduceList= formsDesignApplication.getDBFunctionsOrProceduce("PROCEDURE",queryRequest.getFormNo().toUpperCase()+ Constant.PROC_PREFIX);
        Map <String, Object> procduceMapList=new LinkedHashMap();
        for (Map model :procduceList){
            procduceMapList.put(model.get("objectName").toString(), model.get("objectName").toString());
        }
        this.putAttribute("procedureNameList",procduceMapList);

        this.putAttribute("buttonType",sdo.getString("type"));
        return forward("customButtonDetail",formButtons);
    }

    //保存自定义的按钮
    public String saveCustomButton(){
        SDO sdo = this.getSDO();
        String btnName=sdo.getString("buttonName");
        String btnValue=sdo.getString("buttonValue");
         FormButtons  entity = (FormButtons) sdo.toObject(FormButtons.class);
        //SafFormslist forms=this.safFormslistRepository.findOne(sdo.getString("id"));
         String  id=this.powerConfigApplication.saveCustomButton(entity);

        //{"buttonName":"按钮","buttonMethodName":"addRow","modelName":"SMS_TABLE_DETAIL",
        // "buttonMethodName_text":"新增行","id":"7AE6AD549C7749AC8CBA23AAA8F85FE4",
        // "buttonKey":"button_1608535618891","modelName_text":"测啊"}
        return success(id);
    }

}
 