package com.huigou.uasp.form.controller;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.configuration.application.CommonTreeApplication;
import com.huigou.uasp.bmp.configuration.domain.model.CommonTree;
import com.huigou.uasp.bmp.configuration.repository.CommonTreeRepository;
import com.huigou.uasp.bmp.opm.proxy.AccessApplicationProxy;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.DataPermissionApplication;
import com.huigou.uasp.form.domain.model.FormAttribute;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.repository.FormAttributeRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@Controller
@ControllerMapping("formDataPermission")
public class DataPermissionController extends CommonController {

    @Autowired
    private DataPermissionApplication dataPermissionApplication;
    @Autowired
    private SafFormslistRepository safFormslistRepository;
    @Autowired
    private FormAttributeRepository formAttributeRepository;
    @Autowired
    private CommonTreeRepository commonTreeRepository;

    @Autowired
    private CommonTreeApplication commonTreeApplication;


    @Autowired
    private AccessApplicationProxy accessApplication;

    protected String getPagePath(){
        return "/formdesign/forms/";
    }

     //查询数据管理权限列表
    /*
     * parm:formNo
     */
    public String slicedQueryDataManageTypes(){
        SDO sdo = this.getSDO();
        SafFormsQueryRequest queryRequest = sdo.toQueryRequest(SafFormsQueryRequest.class);
        List<Map<String, Object>> data=null;
        data=dataPermissionApplication.queryDataManageTypes(queryRequest);
        return packGridDataAndResult(data);
    }

    //查询界面元素权限的树节点
    public String  queryUIElementFolderId() {
        SDO sdo = getSDO();
        Integer kindId=16;
        String formNo = sdo.getString("formNo");
        Map<String, Object> data = new HashMap<String, Object>();
        CommonTree comtree=commonTreeApplication.findByKindIdAndCode(kindId,formNo+"UI");
        String parentId="";
        if  (comtree!=null){
            parentId=comtree.getId();
        } else {
            String formId = sdo.getString("formId");
            SafFormslist safFormslist=safFormslistRepository.findOne(formId);
            Long zs=commonTreeRepository.countByParentId(kindId.toString());
            comtree=new  CommonTree();
            comtree.setKindId(kindId);
            comtree.setParentId(kindId.toString());
            comtree.setCode(formNo+"UI");
            comtree.setName(safFormslist.getFormName());
            comtree.setNodeKind(CommonTree.NodeKind.FOLDER);
            comtree.setSequence(zs.intValue()+1);
            parentId=commonTreeApplication.insert(comtree);
        }
        String elementCode= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,sdo.getString("tableName"))+"Grid"; //驼峰法
        ///comtree=commonTreeApplication.findByKindIdAndCode(kindId,formNo+"UI");
       // smsOrderGrid.addHandler
       // smsOrderDetailGrid.field2
        if ("1".equals(sdo.getString("ptype"))) { //是字段
            List<FormAttribute> list = formAttributeRepository.findByFormIdAndTable(sdo.getString("formId"), sdo.getString("tableName"));
            String field = "";
            int tableType=1;
            for (int u = 0; u < list.size(); u++) {
                if (list.get(u).getAttrCode().equals(sdo.getString("attrCode"))) {
                    field = "field" + u;
                    tableType=list.get(u).getTableType();
                    break;
                }
            }
            if (tableType==1){  //主表
                elementCode=field;
                data.put("kindId","0");
            } else {    //子表
                elementCode +="."+field;
                data.put("kindId","1");
            }
            data.put("elementName", sdo.getString("attrName") + "操作权限");
        } else { //按钮
            elementCode+="."+sdo.getString("attrCode");
            data.put("elementName","无"+sdo.getString("attrName")+"权限");
            data.put("kindId","2");
        }
       //kindId: 2 按钮  1 子集  0主集
         data.put("folderId",parentId);
         data.put("elementCode",elementCode);
        return toResult(data);

    }

    //@LogInfo(logType = LogType.SYS, subType = "", operaionType = OperationType.LIST, description = "跳转到界面元素权限页面")
    public String showFrmUIElementPermission() {
        SDO params = this.getSDO();
        String permissionId = params.getString("permissionId");
        this.putAttribute("permissionId", permissionId);

        Map<String, Object> operations = accessApplication.queryUIElementOperations();
        this.putAttribute("uiElementOperations", operations);
        this.putAttribute("formId", params.getString("formId"));
        return forward("/focus/frmUIElementPermission");
    }

    public String showSelectUIElementDetail() {
        SDO params = this.getSDO();
        String permissionId = params.getString("permissionId");
        this.putAttribute("permissionId", permissionId);

      //  Map<String, Object> operations = accessApplication.queryUIElementOperations();
      //  this.putAttribute("uiElementOperations", operations);
        this.putAttribute("formId", params.getString("formId"));
        return forward("/focus/selectUIElementDetail");
    }


    public String slicedQueryUIElements(){
        SDO sdo = this.getSDO();
        SafFormsQueryRequest queryRequest = sdo.toQueryRequest(SafFormsQueryRequest.class);
        List<Map<String, Object>> data=null;
            data = dataPermissionApplication.queryUIElementFields(queryRequest);
        List<Map<String, Object>> newdata=new ArrayList<Map<String, Object>>();
        Map newMap=new HashMap();
        for (Map map:data) {
            newMap = new HashMap();

            newMap.put("name", map.get("name").toString());
            String elementCode = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, map.get("tableName").toString()) + "Grid"; //驼峰法
            // String ptype= map.get("ptype").toString();
            if ("1".equals(map.get("ptype").toString())) { //是字段
                List<FormAttribute> list = formAttributeRepository.findByFormIdAndTable(sdo.getString("id"), map.get("tableName").toString());
                String field = "";
                int tableType = 1;
                for (int u = 0; u < list.size(); u++) {
                    if (list.get(u).getAttrCode().equals(map.get("attrCode").toString())) {
                        field = "field" + u;
                        tableType = list.get(u).getTableType();
                        break;
                    }
                }
                if (tableType == 1) {  //主表
                    elementCode = field;
                    newMap.put("permissionType", "0");
                } else {    //子表
                    elementCode += "." + field;
                    newMap.put("permissionType", "1");
                }
                newMap.put("attrName", map.get("attrName").toString() + "操作权限");
            } else { //按钮
                elementCode += "." + map.get("attrCode").toString();
                newMap.put("attrName", "无" + map.get("attrName") + "权限");
                newMap.put("permissionType", "2");
            }
            newMap.put("attrCode",elementCode);
            newdata.add(newMap);
        }
        return packGridDataAndResult(newdata);
    }
}
 