package com.huigou.uasp.form.application.impl;
 import java.io.File;
 import java.util.*;
 import java.util.stream.Collectors;

 import com.huigou.cache.SystemCache;
 import com.huigou.context.Operator;
 import com.huigou.context.ThreadLocalUtil;
 import com.huigou.uasp.bmp.configuration.application.CodeBuildRuleApplication;
 import com.huigou.uasp.bmp.configuration.domain.model.CodeBuildRule;
 import com.huigou.uasp.bmp.configuration.repository.CodeBuildRuleRepository;
 import com.huigou.uasp.bmp.opm.domain.model.access.Permission;
 import com.huigou.uasp.bmp.opm.domain.model.access.RolePermission;
 import com.huigou.uasp.bmp.opm.repository.org.PermissionRepository;
 import com.huigou.uasp.bmp.opm.repository.org.RolePermissionRepository;

 import com.huigou.uasp.bpm.managment.domain.model.ProcDefinition;
 import com.huigou.uasp.builder.vo.ButtonDefineVO;
 import com.huigou.uasp.form.domain.model.*;
 import com.huigou.uasp.form.domain.query.FormTreeQueryRequest;
 import com.huigou.uasp.form.repository.*;
 import com.huigou.uasp.meta.application.MetaDataApplication;
 import com.huigou.uasp.model.application.DbTablesApplication;
 import com.huigou.uasp.model.repository.DbTablesRepository;

 import com.huigou.util.ClassHelper;
 import org.springframework.util.Assert;


 import com.google.common.base.CaseFormat;
//import com.huigou.util.CommonUtil;
//import com.huigou.util.SDO;
//import com.huigou.uasp.util.Utils;
import com.huigou.uasp.util.Constant;
import com.huigou.uasp.util.Utils;

import org.springframework.transaction.annotation.Transactional;

import com.huigou.uasp.bmp.common.application.BaseApplication;
 import com.huigou.uasp.bmp.opm.domain.model.resource.SysFunction;
 import com.huigou.uasp.bmp.opm.proxy.SysFunctionApplicationProxy;
import com.huigou.uasp.bmp.opm.repository.org.SysFunctionRepository;
import com.huigou.uasp.builder.BuildTypeClass;
import com.huigou.uasp.builder.filer.BuildPageDetailFile;
import com.huigou.uasp.builder.vo.ParamFormVO;
import com.huigou.uasp.builder.vo.SeleListCustomVO;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.application.SafFormslistApplication;
 import com.huigou.uasp.form.domain.query.FormParameterQueryRequest;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
 import com.huigou.uasp.meta.repository.MetaDataRepository;
import com.huigou.uasp.model.domain.query.DbTablesQueryRequest;


@Service("safFormslistApplication")
public class SafFormslistApplicationImpl extends BaseApplication implements SafFormslistApplication {

	static String QUERY_XML_FILE_PATH = "config/formdesign/safFormslist.xml";
	private String pagePath = "/customform/";

	@Autowired
	private SafFormslistRepository safFormslistRepository;

	@Autowired
	private FormTreeRepository formTreeRepository;

	@Autowired
	private SysFunctionRepository sysFunctionRepository;

	@Autowired
	private PermissionRepository permissionRepository;

	@Autowired
	private RolePermissionRepository rolePermissionRepository;

	@Autowired
	private MetaDataApplication metaDataApplication;


	@Autowired
	private DbTablesRepository dbTablesRepository;
	@Autowired
	private DbTablesApplication dbTablesApplication;
	@Autowired
	private FormTablesRepository formTablesRepository;

	@Autowired
	private FormButtonsRepository formButtonsRepository;

	@Autowired
	private FormAttributeRepository formAttributeRepository;

	@Autowired
	private MetaDataRepository metaDataRepository;

	@Autowired
	private FormSearchSqlRepository formSearchSqlRepository;

	@Autowired
	private SysFunctionApplicationProxy sysFunctionApplication;

	@Autowired
	private FormParameterRepository formParameterRepository;

	@Autowired
	private CommonUtilApplication commonUtilApplication;
	@Autowired
	private CodeBuildRuleApplication codeBuildRuleApplication;
	@Autowired
	private CodeBuildRuleRepository codeBuildRuleRepository;
	@Autowired
	private BuildTypeClass buildTypeClass;

	@Override
	public Map<String, Object> querySyfForms(SafFormsQueryRequest queryRequest) {
		return this.sqlExecutorDao.executeSlicedQuery(getQueryDescriptor(), queryRequest);
	}

	private QueryDescriptor getQueryDescriptor() {
		return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "querySafFormList");
	}

	private QueryDescriptor getQueryDescriptor(String entityName) {
		return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
	}

	private QueryDescriptor getQueryDescriptor(String filePath, String entityName) {
		return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
	}

	//查询表单的按钮
	@Override
	public List<Map<String, Object>> queryformButtonList(SafFormsQueryRequest queryRequest) {
		// return this.sqlExecutorDao.executeSlicedQuery( getQueryDescriptor(queryRequest.getTableName(),"formButtonList"), queryRequest);
		String sql = getQueryDescriptor(queryRequest.getTableName(), "formButtonList").getSql();
		String  buttonType=queryRequest.getButtonType();
		if  (buttonType.equals("1")){
			//buttonType="1,2";
			return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
		} else {
		    sql = getQueryDescriptor(queryRequest.getTableName(), "formButtonListByType").getSql();
			return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId(),buttonType);
		}
	}

	@Override
	public List<Map<String, Object>> queryDisplayListFields(SafFormsQueryRequest queryRequest) {
		String sql = getQueryDescriptor("gridListFields").getSql();
		return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
	}

	@Override
	public List<Map<String, Object>> queryDisplaySearchFields(SafFormsQueryRequest queryRequest) {
		String sql = getQueryDescriptor("gridSearchFields").getSql();
		return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
	}



	//查询表单配置列表数据
	@Override
	public List<Map<String, Object>> queryFormParameter(FormParameterQueryRequest queryRequest) {

		String sql = "";
		if (queryRequest.getParmType() == 1||queryRequest.getParmType() == 6) {
			sql = getQueryDescriptor("queryFormParameterPrompt").getSql();
		} else if (queryRequest.getParmType() == 2) {
			sql = getQueryDescriptor("queryFormParameterSearchSQL").getSql();
			return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getFormNo());
		} else if (queryRequest.getParmType() == 3) {
			sql = getQueryDescriptor("queryFormFunctionOrProcduce").getSql();
			if (queryRequest.getParmCode()!=null&&!"".equals(queryRequest.getParmCode())){
				return this.sqlExecutorDao.queryToListMap(sql, "FUNCTION", queryRequest.getParmCode().toUpperCase()+"%");
			} else {
				return this.sqlExecutorDao.queryToListMap(sql, "FUNCTION", queryRequest.getFormNo().toUpperCase() + Constant.FUNC_PREFIX + "%");
			}

		} else if (queryRequest.getParmType() == 4) {
			sql = getQueryDescriptor("queryFormFunctionOrProcduce").getSql();
			return this.sqlExecutorDao.queryToListMap(sql, "PROCEDURE",queryRequest.getFormNo().toUpperCase()+Constant.PROC_PREFIX+"%");
		}
		return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getFormNo(), queryRequest.getParmType());

	}


	//查询表单数据字典数据
	@Override
	public List<Map<String, Object>> queryFormDictionary(FormParameterQueryRequest queryRequest) {

		String sql = getQueryDescriptor("queryFormParameterPrompt").getSql();
		sql = " select t.* from sa_dictionary t where 1 = 1 and t.folder_id ";
		sql += " in (select a.id  from sa_commontree a where a.name in (select s.value from sa_parameter s  where code='formDictFolderName')) ";

		return this.sqlExecutorDao.queryToListMap(sql);


	}


	//查询表单配置函数或过程的 内容
	@Override
	public Map<String, Object> queryFormFunctionOrProcduceContent(FormParameterQueryRequest queryRequest) {

		//String sql =getQueryDescriptor("queryFormFunctionOrProcduceContent").getSql();
		QueryModel queryModel = this.sqlExecutorDao.getQueryModel(getQueryDescriptor("queryFormFunctionOrProcduceContent"), queryRequest);
		// queryModel.setPageSize(50);//默认50
		// queryModel.setPageIndex(1);
		String sql = queryModel.getSql();

		sql += " and name='" + queryRequest.getName() + "'";
		if (queryRequest.getParmType() == 3) {
			sql += " and  TYPE='FUNCTION' ";
		} else if (queryRequest.getParmType() == 4) {
			sql += " and  TYPE='PROCEDURE' ";

		}
		// sql+=" and c.form_no='"+queryRequest.getFormNo()+"'";
		queryModel.setSql(sql);

		Map<String, Object> mapData = this.sqlExecutorDao.executeSlicedQuery(queryModel);
		//@SuppressWarnings("unchecked")
		// List<Map<String, Object>> list = (List<Map<String, Object>>) mapData.get("Rows");
		return mapData;
		//return this.sqlExecutorDao.queryToListMap(sql);

	}


	@Override
	public SafFormslist loadSyfForms(String id) {
		Assert.hasText(id, Constant.ID_NOT_BLANK);
		return this.safFormslistRepository.findOne(id);
	}

	@Override
    public Permission getPermission(String formNo) {
	  Permission permission=null;
	   List  <Permission> permissionList=this.generalRepository.query(" from  Permission b where b.code='"+formNo+"_custom'");
	   if (permissionList.size()>0){
		   permission=permissionList.get(0);
		}
	return  permission;
}

 @Transactional
 @Override
public void deleteSyfFormsByIds(List<String> ids) {
   List<SafFormslist> list = this.safFormslistRepository.findAll(ids);
   if (list.size()>0) { //旧的方式  来源表单列表

	   for (String formId : ids) {
		   //删除关联属性
		   this.formAttributeRepository.deleteFormAttribute(formId);
		   //删除数据模型
		   List <FormTables> tableList=formTablesRepository.findByFormId(formId);
		   List<String> listIds = new ArrayList<String>();
		   for (FormTables tables:tableList){
			   listIds.add(tables.getTableId());
		   }
		   dbTablesApplication.deleteUserTables(listIds);
		   //删除关联表
		   this.formTablesRepository.deleteFormTables(formId);
		   //删除按钮
		   this.formButtonsRepository.deleteFormButtons(formId);
		   //删除表单树

		   for (SafFormslist form : list) {
			   List<FormTree> treeList = this.formTreeRepository.findByCode(form.getFormNo());
			   if (treeList != null && treeList.size() > 0) {
				   this.formTreeRepository.deleteFormTreeByParentId(treeList.get(0).getId());
				   this.formTreeRepository.deleteFormTreeByCode(form.getFormNo());
			   }
		   }
	   }


   } else {  ////从表单树中点击删除
	   List<FormTree>  list2=this.formTreeRepository.findAll(ids);
	   List<SafFormslist> formslist=this.safFormslistRepository.findByFormNo(list2.get(0).getCode());
	   String formId=formslist.get(0).getId();
       //删除关联属性
	   this.formAttributeRepository.deleteFormAttribute(formId);
	   //删除数据模型
	   List <FormTables> tableList=formTablesRepository.findByFormId(formId);
	   List<String> listIds = new ArrayList<String>();
	    for (FormTables tables:tableList){
		   listIds.add(tables.getTableId());
	    }
	   dbTablesApplication.deleteUserTables(listIds);
	   //删除关联表
	   this.formTablesRepository.deleteFormTables(formId);
	   //删除按钮
	   this.formButtonsRepository.deleteFormButtons(formId);
	   //删除表单树
	   this.formTreeRepository.deleteFormTreeByParentId(list2.get(0).getId());
	   this.formTreeRepository.deleteFormTreeByCode(list2.get(0).getCode());
   }

     this.safFormslistRepository.delete(list);
  }
 
 
 @Override
  public List<Map<String, Object>> queryTableProperty(SafFormsQueryRequest queryRequest) {
		String sql = null;
		sql = getQueryDescriptor(queryRequest.getTableName(),"tableProperty").getSql();
		return this.sqlExecutorDao.queryToListMap(sql,queryRequest.getTableName(),queryRequest.getTableName(),queryRequest.getId());
	}
 


	//保存按钮
		@Override
		@Transactional
		public  String saveFormButtonLists(String formId,String tableName,List<FormButtonVO> blist) {
			//String btnNames="",btnValues="";
			FormButtons formButtons=null;
			//先删除按钮
			formButtonsRepository.deleteFormButtons(formId);
			for (int i=0;i<blist.size();i++) { 
				//btnNames+=blist.get(i).getButtonName();
				//btnValues+=blist.get(i).getButtonValue();
				formButtons=new FormButtons();
				formButtons.setId(Utils.createUuid());
				formButtons.setFormId(formId);
				formButtons.setButtonKey(blist.get(i).getButtonValue().replace("Handler",""));
				formButtons.setButtonName(blist.get(i).getButtonName());
				formButtons.setButtonType(1);
				formButtons.setProcedureName(blist.get(i).getProcedureName());
				formButtons.setStatus(1);
				formButtons.setSequence(i+1);
				formButtons.setButtonMethodName(blist.get(i).getButtonValue().replace("Handler",""));
				formButtonsRepository.save(formButtons);
			}
			// SafFormslist syfForms=safFormslistRepository.findOne(id);
			// syfForms.setFormbuttonsName(btnNames);
			// syfForms.setFormbuttonsMethodName(btnValues);
			// formButtonsRepository.save(arg0);
			 
			return formId;	
		}
	

	//保存表单参数
	@Override
	@Transactional
	public  String saveFormParameter(FormParameter  formParameter){
		formParameter=this.formParameterRepository.saveAndFlush(formParameter);
	    return formParameter.getId();

   }
		//删除自定义按钮
			@Override
			@Transactional
		public String deleteCustomButton(String formId,String btnName,String btnValue){
		   this.formButtonsRepository.deleteFormButtonsByKey(formId,btnValue);
			return formId;		
	   }
		    
	@Override
	@Transactional
	//删除表单设置信息
	public void deleteFormSettings(String parmType,List<String> ids) {
		
		   if ("2".equals(parmType)) {  //EasySearch
		        List<FormSearchSql> list = this.formSearchSqlRepository.findAll(ids); 
			   this.formSearchSqlRepository.delete(list);
		   } else if ("1".equals(parmType)) {  //表单提示
			   List<FormParameter> list = this.formParameterRepository.findAll(ids);
			   this.formParameterRepository.delete(list);
		  }
			
	  }
		 
	//保存列表显示字段
	   @Override
  	  @Transactional
	  public  String saveDisplayListFields(String formId,List<FormAttribute> blist){
		  
		   //将显示字段 都关闭
		   this.formAttributeRepository.updateDisplayListing(0, formId);
		   FormAttribute formAttribute=null;
			for (int i=0;i<blist.size();i++) { 
				formAttribute=blist.get(i);
                int width=formAttribute.getWidth();
				formAttribute=formAttributeRepository.findOne(formAttribute.getId());
				formAttribute.setDisplayListing(1);
                formAttribute.setWidth(width);
				formAttributeRepository.save(formAttribute);
			}
		   return formId;
	   }
	   
	   //保存查询条件字段
	   @Override
    	@Transactional
	  public  String saveSearchFields(String formId,List<FormAttribute> blist){
		   //将默认查询条件字段 都关闭
		   this.formAttributeRepository.updateSearchField(0, formId);
		   FormAttribute formAttribute=null;
			for (int i=0;i<blist.size();i++) { 
				formAttribute=blist.get(i);
				formAttribute=formAttributeRepository.findOne(formAttribute.getId());
				formAttribute.setSearchField(1);
				formAttributeRepository.save(formAttribute);
			}
		   return formId;
		   
	   }
		    

	//查询待选择的数据模型
	@Override
	public Map<String, Object>  queryAlternativeTableLists(SafFormsQueryRequest queryRequest){
		QueryDescriptor queryDescriptor = getQueryDescriptor("alternativeTableData");
		Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryDescriptor,queryRequest);
		return  map;
	}

 // 查询已经选择的数据模型 
	@Override
	public  List<Map<String, Object>> querySelectedTableLists(SafFormsQueryRequest queryRequest) {
		String sql= getQueryDescriptor("selectedTableData").getSql();
		List<Map<String, Object>> data = this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
		return data;
		
	}
	
	 //保存表单
	@Override
	@Transactional
	public  String saveSafForms(SafFormslist safFormslist,List <Object>plist){
		Map <String,Object>map=null;
		SafFormslist safForms=null;
		String backStr="";
 	   //判断是否存在主表单
		boolean existMainTable=false;
		 for (int i=0;i<plist.size();i++) {
			map=(Map<String,Object>)plist.get(i);
 		   // String tableType=map.get("tableType").toString();
 		    if ("1".equals(map.get("tableType").toString())){
 		    	existMainTable=true;
 		    	break;
 		    }
		 }
		// if (!existMainTable){
		//	throw new IllegalArgumentException("表单编号"+safFormslist.getFormNo()+"：没有设置主表！");
		// }
		//判断是否是修改
		if (safFormslist.getId()!=null&&!"".equals(safFormslist.getId())){
			safForms=safFormslistRepository.findOne(safFormslist.getId());
			safForms.setFormNo(safFormslist.getFormNo());
			safForms.setFormName(safFormslist.getFormName());
			safForms.setSaveMode(safFormslist.getSaveMode());
		    List <FormTables>tableLists=this.formTablesRepository.findByFormId(safFormslist.getId());
		    for (FormTables table:tableLists){
		       this.formTablesRepository.delete(table);
		    }
		   List <FormTree> formTreeList=this.formTreeRepository.findByCode(safFormslist.getFormNo());
		    if (formTreeList.size()>0){
				safFormslist.setParentId(formTreeList.get(0).getParentId());
				this.formTreeRepository.deleteFormTreeByParentId(formTreeList.get(0).getId());
				this.formTreeRepository.deleteFormTreeByCode(safFormslist.getFormNo());
			}
		} else {  //新增
			safForms=new SafFormslist();
			List <SafFormslist>dblist=this.safFormslistRepository.findByFormNo(safFormslist.getFormNo());
		    if (dblist!=null&&dblist.size()>0){	
			   backStr="表单编号已经存在！";
			   throw new IllegalArgumentException("表单编号"+safFormslist.getFormNo()+"已经存在！");
		    }
		    safForms.setFormNo(safFormslist.getFormNo());
		    safForms.setFormName(safFormslist.getFormName());
		    safForms.setPackageName(safFormslist.getFormNo());
		    safForms.setFormPath(safFormslist.getFormNo());
		    safForms.setSaveMode(safFormslist.getSaveMode());
		    /*
		   if (safFormslist.getPagedatailCols()!=null){
			   safForms.setPagedatailCols(safFormslist.getLabelCols());
		   } else {
			   safForms.setPagedatailCols(Integer.parseInt(Constant.PAGEDETAIL_COLS));
		   }
		   if (safFormslist.getLabelCols()!=null){
			   safForms.setLabelCols(safFormslist.getLabelCols());
		   } else {
			   safForms.setLabelCols(Integer.parseInt(Constant.LABEL_COLS));
		   }
		   if (safFormslist.getFieldCols()!=null){
			   safForms.setFieldCols(safFormslist.getFieldCols());
		   } else {
			   safForms.setFieldCols(Integer.parseInt(Constant.FIELD_COLS));
		   }
		   if (safFormslist.getTextareaRows()!=null){
			   safForms.setTextareaRows(safFormslist.getTextareaRows());
		   } else {
			   safForms.setTextareaRows(Integer.parseInt(Constant.TEXTAREA_ROWS));
		   }*/
		 /*  if (safFormslist.getExistAttachment()!=null){
			   safForms.setExistAttachment(safFormslist.getExistAttachment());
		   } else {
			   safForms.setExistAttachment(0);
		   }*/
	  
		   // safForms.setName(queryRequest.getName());
		}
		    safForms=this.safFormslistRepository.saveAndFlush(safForms);
		    safForms.setParentId(safFormslist.getParentId());

		    addFormTree(safForms);

		    FormTables formTables=null;
         //保存表信息 
		for (int i=0;i<plist.size();i++) {
			map=(Map<String,Object>)plist.get(i);
			String tableId=map.get("id").toString();
			//String fieldName=map.get("fieldName").toString();
			String tableName=map.get("tableName").toString();
			String tableType=map.get("tableType").toString();
			
			formTables=new FormTables();
			
			formTables.setId(Utils.createUuid());
			formTables.setTableId(tableId);
			formTables.setFormId(safForms.getId());
			formTables.setTableName(tableName);
			formTables.setTableType(Integer.parseInt(tableType));
			formTables.setDisplayNums(i+1);
			//tablesMeta.setFieldCode(fieldCode);
			//tablesMeta.setNums(Integer.parseInt(map.get("nums").toString()));
			 formTables.setStatus(1);
			this.formTablesRepository.save(formTables);
			
		//	queryRequest.setTableName(tableName);
		   // QueryModel queryModel = this.sqlExecutorDao.getQueryModel(getQueryDescriptor("dbTablesByName"),queryRequest);
			//map=this.sqlExecutorDao.executeQuery(queryModel);
	
		}
		return backStr;
		
	}

	public void addFormTree(SafFormslist safForms){

		FormTree formTree=new FormTree();
		//String uuId=Utils.createUuid();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo());
		formTree.setName(safForms.getFormName());
		formTree.setParentNodeType("2");
		formTree.setStatus(1);
		formTree.setParentId(safForms.getParentId());

		formTree=this.formTreeRepository.saveAndFlush(formTree);
		String uuId=formTree.getId();

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_datamodel");
		formTree.setName("数据模型");
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setSequence(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_basicdata");
		formTree.setName("基础数据");
		formTree.setSequence(2);
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_power");
		formTree.setName("能力配置");
		formTree.setSequence(4);
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_design");
		formTree.setName("表单设计");
		formTree.setSequence(3);
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_process");
		formTree.setName("流程设计");
		formTree.setSequence(5);
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);

		formTree=new FormTree();
		formTree.setId(Utils.createUuid());
		formTree.setCode(safForms.getFormNo()+"_print");
		formTree.setName("打印模板");
		formTree.setSequence(6);
		formTree.setParentNodeType("3");
		formTree.setStatus(1);
		formTree.setParentId(uuId);

		this.formTreeRepository.save(formTree);
	}
	
	
	 //生成菜单信息
	@Override
	public  Map<String, Object> produceMenuList(SafFormsQueryRequest queryRequest){
		Map <String,Object>map=new HashMap<String,Object>();
		
		SafFormslist  formList=this.safFormslistRepository.findOne(queryRequest.getId());
		
		String url="/menuManage/forwardPageList.do?formNo="+formList.getFormNo();
		
		SysFunction  parentSysFunction =sysFunctionRepository.findByCode("customMenu");
		
		SysFunction  function =sysFunctionRepository.findByCode(formList.getFormNo()+"_custom");
		if (function==null){
			map.put("result","");
		  SysFunction  sysFunction=new SysFunction();
		  String id=Utils.createUuid();
		  sysFunction.setId(id);
		  sysFunction.setCode(formList.getFormNo()+"_custom");
		  sysFunction.setName(formList.getFormName());
		  sysFunction.setUrl(url);
		  sysFunction.setParentId(parentSysFunction.getId());
		  sysFunction.setNodeKindId("fun");
		  sysFunction.setIcon("fa-file");
		  sysFunction.setFullId(parentSysFunction.getFullId()+"/"+id);
		  sysFunction.setFullName(parentSysFunction.getFullName()+"/"+formList.getFormName());
		  sysFunction.setStatus(1);
		  sysFunction=sysFunctionRepository.saveAndFlush(sysFunction);
	
		  //构建权限
		  sysFunctionApplication.buildPermission(sysFunction.getFullId());

		  //授权给当前用户的角色
			Operator operator = ThreadLocalUtil.getOperator();
			List <String> roleIds=operator.getRoleIds();
			String roleId=roleIds.get(0);//

			//select t.* from sa_oprolepermission t  where t.role_id='298'  and t.permission_id='CF03FD3720E34B2A8B115E87E0A789E6'

			Permission permission=this.permissionRepository.findFunctionByResourceId(sysFunction.getId());

			List<Permission> permissionList=this.permissionRepository.findByParentIdAndResourceKindId(permission.getId(),"fun");

			RolePermission rolePermission=new RolePermission();
			rolePermission.setId(Utils.createUuid());
			rolePermission.setRoleId(roleId);
			rolePermission.setPermissionId(permission.getId());

			rolePermissionRepository.saveAndFlush(rolePermission);

            for (Permission object:permissionList){
				rolePermission=new RolePermission();
				rolePermission.setId(Utils.createUuid());
				rolePermission.setRoleId(roleId);
				rolePermission.setPermissionId(object.getId());
				rolePermissionRepository.saveAndFlush(rolePermission);
			}
		}else {
			map.put("result", Constant.MENU_CODE_EXIST);
		}
		return map;
	}


	 /*
     * 生成表单的页面文件
     * queryRequest:需要参数formNo
     */
    public String produceGenerateFile(String  formNo) {
    	String backStr="";
        String webPath = this.getClass().getClassLoader().getResource("/").getPath();
        webPath = webPath.substring(1, webPath.length() - 16);
        webPath += pagePath;
        File file=new File(webPath);
        if (!file.exists()){
        	file.mkdir();
        }
        SafFormslist  safFormslist=this.safFormslistRepository.findByFormNo(formNo).get(0);
        webPath+=safFormslist.getFormNo();
        file=new File(webPath);
        if (!file.exists()){
        	file.mkdir();
        }
        String tableName=commonUtilApplication.getTablesByFormId(safFormslist.getId(),1);
		 tableName=tableName.split(",")[0];  //取第一个主表 
		// queryRequest.setTableName(tableName.toUpperCase());
		SafFormsQueryRequest queryRequest=new SafFormsQueryRequest();
		queryRequest.setId(safFormslist.getId());
		queryRequest.setTableName(tableName.toUpperCase());
		queryRequest.setFormNo(formNo);
		//queryRequest.setExistAttachment(safFormslist.getExistAttachment());

        String pageName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,tableName); //转驼峰法
        String filePathName = webPath + "/" + pageName + ".jsp";
        file = new File(filePathName);

    	// 重新发布 需要删除已经生成的页面文件
		if (file.exists()) {
    	   file.delete();
    	}
    	   
        if (!file.exists()) {

            ParamFormVO paraForm = this.getFieldAttributes(queryRequest);
            
            DbTablesQueryRequest dbqueryRequest=new DbTablesQueryRequest();    
            dbqueryRequest.setTableName(tableName.toUpperCase());

			List <String> hiddenField=commonUtilApplication.queryTableHiddenFields(dbqueryRequest,1);
			boolean existField=false;
			for (String str:hiddenField) {
				if (str.equals("formId")){
					existField=true;
					break;
				}
			}
			if (!existField) {
				hiddenField.add("formId");  //默认主表增加 formId
			}
			if (paraForm.getAttachmentLists().size()>0){
				hiddenField.add("attbizid");
			}
			paraForm.setHiddenFields(hiddenField);
            paraForm.setIsform(1);
            paraForm.setTableName(tableName);//主表名称 
            paraForm.setFormPath(webPath);
			paraForm.setUploadPath("");  //页面文件 直接生成在运行目录 
            paraForm.setSrcPath(pagePath); 

            paraForm.setFormName(safFormslist.getFormName());

            //查询台账页面配置的按钮
			this.addParaFormButtons(safFormslist.getId(),"",paraForm);

			// 生成默认的编码规则
			if (this.generalRepository.query("from CodeBuildRule where code='"+safFormslist.getFormNo()+"'").size()<1){
				CodeBuildRule codeRule =new CodeBuildRule();
				String ruleFolderName = SystemCache.getParameter("formRuleFolderName", String.class);
				String ruleFolderIds = this.metaDataApplication.getMdmUserDictFolderIds(ruleFolderName);
				codeRule.setFolderId(ruleFolderIds);
				codeRule.setCode(safFormslist.getFormNo());
				codeRule.setName(safFormslist.getFormName()+"编码规则");
				codeRule.setStatus(1);
				codeRule.setRule(safFormslist.getFormNo()+"{yyyymmss}{4}");
				codeRule.setCurrentValue(1);
				codeRule.setLastModifiedDate(new Date());
				codeBuildRuleApplication.saveCodeBuildRule(codeRule);
			}
			try {

                BuildPageDetailFile buildPageDetailFile = new BuildPageDetailFile();
				StringBuffer sb = buildPageDetailFile.generateContents(paraForm,tableName);
                buildPageDetailFile.generateFile(filePathName, sb);
                
                Thread.sleep(1000);
                buildTypeClass.getBuildClass(Constant.BUILD_PAGELIST).generateFile(paraForm,null);
                
                Thread.sleep(1000);
    	        buildTypeClass.getBuildClass(Constant.BUILD_PAGEJS).generateFile(paraForm,null);
    	        
                Thread.sleep(1000);

				if (safFormslist.getPublished()==null||(safFormslist.getPublished()!=null&&safFormslist.getPublished()==0)) {
					safFormslist.setPublished(1);
					this.safFormslistRepository.saveAndFlush(safFormslist);
				}

            } catch (Exception e) {
				backStr=e.getMessage();
                e.printStackTrace();
            }
        }
		return backStr;
    }
    
    
    /**
     * 拼装数据对象属性
     *
     * @param queryRequest: （id）formId、formNo 、tableName
     * @return
     */
    public ParamFormVO getFieldAttributes(SafFormsQueryRequest queryRequest) {
         //获取主表字段 进行拼装 getBtnMethodNames
      //  List<Map<String, Object>> singleList = commonUtilApplication.queryDataRecordSingleFields(queryRequest.getId(),queryRequest.getTableName());

		List<Map<String, Object>> singleList = commonUtilApplication.queryFormAllAttributes(queryRequest.getId(),queryRequest.getTableName());
        ParamFormVO paraForms = Utils.composeAttributes(singleList, queryRequest.getTableName(), "", null);
		//List  procDefinitionList=this.generalRepository.query(" from  ProcDefinition where nodeKindId='proc' and formNo='"+queryRequest.getFormNo()+"'");
		paraForms.setProcId(commonUtilApplication.getProcDefinitionByFormNo(queryRequest.getFormNo()));

         //拼装检索SQL到参数中　
        List <FormSearchSql> customlists=formSearchSqlRepository.searchSqlByFormNo(queryRequest.getFormNo());
	       List <SeleListCustomVO> listCustoms=new  ArrayList<SeleListCustomVO>();
	       SeleListCustomVO customVO=null;Map <String, Object>map=null;
	       String []fieldEns=null;
	       List<String> hiddenFields=new ArrayList<String>();
	       String backFields="",paramSourceFields="";
	       for (int i=0;i<customlists.size();i++){
	    	   customVO=new SeleListCustomVO();
	    	   Utils.CopyBean(customlists.get(i),customVO);
	    	   singleList = commonUtilApplication.queryFormAllAttributes(queryRequest.getId(),customVO.getTableName());
	    	   fieldEns=new String[singleList.size()];

	           //增加参数来源的字段顺序号
	           addParamFieldNum(queryRequest.getId(),customVO);
	           
	           if (customVO.getBackFields()!=null){
	        	  backFields=CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,customVO.getBackFields()); //转成驼峰法
	        	  customVO.setBackFields(backFields);
	           }
	           
	    	  if (customVO.getParamSourceFields()!=null){
	    	     paramSourceFields=CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,customVO.getParamSourceFields()); //转成驼峰法
	    		 customVO.setParamSourceFields(paramSourceFields);
	    	  }
	    	  for (int j=0;j<singleList.size();j++){
	    		   map=singleList.get(j);
	    		   fieldEns[j]=map.get("fieldCode").toString();
	    	  }

			  for (int j=0;j<singleList.size();j++){
	    		   map=singleList.get(j);
	    		 if (customVO.getTargetField()!=null&&customVO.getTargetField().equals(map.get("fieldCode").toString())){
	    			customVO.setTargetNum(j);  //目标字段顺序号
	    			break;
	    		  }
	    	   }
	    	   customVO.setFieldEns(fieldEns);  //关联字段的真实字段名称
	    	   hiddenFields.addAll(Utils.getHiddenFields(customVO));
	      	   listCustoms.add(customVO);
	       }

	       paraForms.setSelectCustoms(listCustoms);
           paraForms.setHiddenFields(hiddenFields);
		   paraForms.setFormPath(queryRequest.getFormNo());
           //添加文件附件参数
		  //List <FormParameter> attachlists=this.formParameterRepository.findByFormNoAndParmType(queryRequest.getFormNo(),5);
		//List  <FormAttribute>attachlists=this.formAttributeRepository.findByFormIdAndTableFieldTag(queryRequest.getId(),queryRequest.getTableName(),"file");
		 /* if (attachlists!=null&&attachlists.size()>0){
			  paraForms.setExistAttachment(1);
			  List  <FormAttachVO> attachlist=new ArrayList<>();
			  for (FormAttribute formAttribute:attachlists){
				  FormAttachVO formAttachVO=new FormAttachVO();
				  Utils.CopyBean(formAttribute,formAttachVO);
				  attachlist.add(formAttachVO);
			  }
			  paraForms.setAttachmentLists(attachlist);
		   }*/
      	  return getDetailTables(queryRequest,paraForms);
    }

    //判断是否存在明细表的情况
	//参数： SafFormsQueryRequest(id：formId,formNo,tableName)
	@Override
    public  ParamFormVO getDetailTables(SafFormsQueryRequest queryRequest,ParamFormVO paraForms){
		//判断是否存在明细表
		String mainTableName=queryRequest.getTableName().toLowerCase();//获取主表
		queryRequest.setTableType(2);
		queryRequest.setTableName(mainTableName);
		List<Map<String, Object>> multsList=this.queryExistTables(queryRequest);
		List<ParamFormVO> details = new ArrayList<ParamFormVO>();
		if (multsList != null && multsList.size() > 0) {//多值则产生明细表
			ParamFormVO paramVO =null;
			List<String> hiddenField=new ArrayList<String>();
			hiddenField.add("id");
			hiddenField.add("parentId");

			Map<String, Object> map =null;
			List<Map<String, Object>> list=null;

			//boolean  existTabLabel=false; //是否存在页签
			List <String> tabs=new ArrayList<>();
			for (int i = 0; i < multsList.size(); i++) {
				map = multsList.get(i);
				String []tabLabel=map.get("tabLabel").toString().split(Constant.TAB_SEPARATE);
				if  (!"".equals(map.get("tabLabel").toString())&&!tabs.contains(tabLabel[0]))
				   tabs.add(tabLabel[0]);
			}

			paraForms.setTabLabels(tabs);  //添加明细表页面的tabs

			for (int i = 0; i < multsList.size(); i++) {
				map = multsList.get(i);
				queryRequest.setTableName(map.get("tableName").toString());
				list = this.commonUtilApplication.queryDataRecordMultsFields(queryRequest.getId(),map.get("tableName").toString());
				paramVO = Utils.composeAttributes(list, map.get("tableName").toString(), map.get("name").toString(), hiddenField);

				paramVO.setFormName(map.get("subTableTitle").toString());
				paramVO.setDisplayMode(map.get("displayMode")!=null?map.get("displayMode").toString():"");
				paramVO.setDisplayFieldnames(paramVO.getFieldChs());
				paramVO.setDisplayFields(paramVO.getFieldEns());
				paramVO.setDisplayFieldTypes(paramVO.getValidatorTypes());
				paramVO.setSrcPath(pagePath);
				paramVO.setSelectCustoms(paraForms.getSelectCustoms());
				paramVO.setIsform(1);  //是表单生成器
				paramVO.setFormPath(queryRequest.getFormNo());
				paramVO.setMainTableName(mainTableName);
				//paramVO.setExistAttachment(paraForms.getExistAttachment());
				paramVO.setAttachmentLists(paraForms.getAttachmentLists());

				addParaFormButtons(queryRequest.getId(),queryRequest.getTableName(),paramVO);

				details.add(paramVO);
			}

		}
		paraForms.setDetails(details);
		return paraForms;
	}

    //添加按钮到ParamFormVO对象
	public void  addParaFormButtons(String formId,String tableName,ParamFormVO paraForm){
		  List <FormButtons>buttonLists=new ArrayList<>();
		  List <ButtonDefineVO> buttonDefineVOList=new ArrayList<>();
    	  if  (!"".equals(tableName)){  //查询明细表格的按钮
			  buttonLists = this.formButtonsRepository.findByFormIdAndTableName(formId,tableName);
			  if ("table".equals(paraForm.getDisplayMode())) {
				 //以子表单方式显示的明细表的页面添加默认按钮
				 addDetailDefaultButton(buttonDefineVOList, buttonLists, "addRow", "新增行");
				 addDetailDefaultButton(buttonDefineVOList, buttonLists, "saveRow", "保存行");
				 addDetailDefaultButton(buttonDefineVOList, buttonLists, "deleteRow", "删除行");
			  }
		  } else {
			  buttonLists = this.formButtonsRepository.findByFormIdNotForm(formId);
		  }
		   ButtonDefineVO buttonDefineVO=null;

           if  (buttonLists.size()>0) {

				for (FormButtons formButton:buttonLists) {
					buttonDefineVO=new ButtonDefineVO();
					ClassHelper.copyProperties(formButton,buttonDefineVO);
					buttonDefineVOList.add(buttonDefineVO);
				}
			}
		paraForm.setButtonDefines(buttonDefineVOList);
	}

	//添加明细页面默认的按钮  放在前面
	public void   addDetailDefaultButton(List <ButtonDefineVO> buttonDefineVOList,List <FormButtons>buttonLists,String buttonMethodName,String buttonName) {
		for (FormButtons formButton:buttonLists) {
			if (buttonMethodName.equals(formButton.getButtonMethodName())){
				buttonLists.remove(formButton);
				break;
			}
		}
			ButtonDefineVO buttonDefineVO = new ButtonDefineVO();
			buttonDefineVO.setButtonName(buttonName);
			buttonDefineVO.setButtonMethodName(buttonMethodName);
			buttonDefineVO.setButtonType(3);
			buttonDefineVOList.add(buttonDefineVO);
	}

    //检索SQL获取参数字段顺序号   //当前表  参数来源表目前只能支持一个主表、一个明细表的情况
    public SeleListCustomVO  addParamFieldNum(String formId,SeleListCustomVO customVO){
    	 
       if (customVO.getParamFields()!=null&&!"".equals(customVO.getParamFields())) {  //存在参数 
    	  String []tables=customVO.getParamSourceTables().split(",");

    	  List<Map<String, Object>> singleList = commonUtilApplication.queryFormAllAttributes(formId,customVO.getTableName());
    	  List<Map<String, Object>> otherList =null;
    	   if (tables.length>1){
    		  String otherTable=tables[0];
    		  if (customVO.getTableName().equals(tables[0])){
    			  otherTable=tables[1];
    		  }
    	      otherList = commonUtilApplication.queryFormAllAttributes(formId,otherTable);
    	   } 
    	      String []paraSourceField=customVO.getParamSourceFields().split(",");
    	      Map <String, Object>map=null;
    	      int []paramSourceNums=new int[paraSourceField.length];
    	      boolean isFound=false;
    	   for (int d=0;d<paraSourceField.length;d++) {
    	    
    	       for (int r=0;r<singleList.size();r++){
	    		   map=singleList.get(r);
	    		   if (paraSourceField[d].equals(map.get("fieldCode").toString())){
	    			   paramSourceNums[d]=r;
	    			   isFound=true;
	    			   break;
	    		   }
    	       }
    	       if  (!isFound && otherList!=null){ //没有找到  再遍历另外一个表
    	    	   for (int r=0;r<otherList.size();r++){
    	    		   map=otherList.get(r);
    	    		   if (paraSourceField[d].equals(map.get("fieldCode").toString())){
    	    			   paramSourceNums[d]=r;
    	    			   isFound=true;
    	    			   break;
    	    		   }
        	       }
    	       }
     	   }
    	   customVO.setParamSourceNums(paramSourceNums);
      }
    	 return customVO;
    }

    //*查询是否存在明细表的属性
    @Override
    public List<Map<String, Object>> queryExistTables(SafFormsQueryRequest queryRequest) {
        Map<String, Object> mapData = new HashMap<String, Object>();
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(getQueryDescriptor("queryFormExistTables"), queryRequest);
        queryModel.setPageSize(101);//默认100
        queryModel.setPageIndex(1);
        String sql=queryModel.getSql();
        if (queryRequest.getTableType()!=0){
        	 sql+=" and a.table_type="+queryRequest.getTableType();
        }
        sql+=" and c.form_no='"+queryRequest.getFormNo()+"'";
		sql+="  order by a.display_nums  ";
        queryModel.setSql(sql);
        
        mapData = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        List<Map<String, Object>> list = (List<Map<String, Object>>) mapData.get("Rows");
        return list;
    }

	 public  Map<String, Object>  queryFormTree(FormTreeQueryRequest queryRequest){

		 return this.sqlExecutorDao.executeQuery(getQueryDescriptor("formTreeQuery"), queryRequest);
	 }


	public  Map<String, Object>  slicedQueryFormTrees(FormTreeQueryRequest queryRequest){
		return this.sqlExecutorDao.executeQuery(getQueryDescriptor("formTreeQueryList"), queryRequest);

      }
	public  Map<String, Object>   queryFormProcessLists(SafFormsQueryRequest queryRequest){

		return this.sqlExecutorDao.executeQuery(getQueryDescriptor("formProcessList"), queryRequest);
	}
	//保存form树文件夹
     public   Map<String, Object>  saveFormFolder(FormTree entity){

		 Map<String, Object> map=new HashMap<String, Object> ();
		 if (entity.getId()!=null){ // 更新
			 FormTree formTree=this.formTreeRepository.findOne(entity.getId());
			 Utils.CopyBean(entity,formTree);
			 this.formTreeRepository.save(formTree);
			 map.put("result","");
		 } else { //

			 List <FormTree> formTreeList=this.formTreeRepository.findByCode(entity.getCode());
			 if (formTreeList.size()>0){
				 map.put("result",entity.getCode()+"已经存在!");
			 } else {
				 entity.setNodeType("1");
				 entity.setStatus(1);
				 entity.setParentId("1");
				 this.formTreeRepository.save(entity);
				 map.put("result","");
			 }
		 }

		 return map;
    }
      //删除form树文件夹
    public  Map<String, Object>  deleteFormFolder(List <String> ids){
		Map<String, Object> map=new HashMap<String, Object> ();
		 List<FormTree> list = this.formTreeRepository.findAll(ids);
		 boolean flag=true;
		 for (String id:ids) {
		  if (this.formTreeRepository.findByParentId(id).size()>0){
		  	map.put("result","存在子节点，不能删除！");
		  	flag=false;
		  	break;
		  }
		 }
		 if  (flag){
			this.formTreeRepository.delete(list);
		 }
		 return map;
	}
}
