package com.huigou.uasp.form.application.impl;

import com.huigou.context.Operator;
import com.huigou.context.ThreadLocalUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.data.domain.query.DataRecordQueryRequest;
import com.huigou.uasp.form.application.DataPermissionApplication;
import com.huigou.uasp.form.application.PowerConfigApplication;
import com.huigou.uasp.form.domain.model.FormButtons;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.repository.FormButtonsRepository;
import com.huigou.uasp.util.Utils;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service("powerConfigApplication")
public class PowerConfigApplicationImpl extends BaseApplication implements PowerConfigApplication {

    static String QUERY_XML_FILE_PATH = "config/formdesign/dbtables.xml";

    static String QUERY_XML_FILE_PATH_FORM= "config/formdesign/safFormslist.xml";

    @Autowired
    private FormButtonsRepository formButtonsRepository;

    private QueryDescriptor getQueryDescriptor(String entityName) {
        return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
    }

    private QueryDescriptor getQueryDescriptorForm(String entityName) {
        return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH_FORM, entityName);
    }

    @Override
    public List<Map<String, Object>> queryFormButtonTableName(SafFormsQueryRequest queryRequest) {
        //SafFormslist safFormslist=this.safFormslistRepository.findOne(queryRequest.getId());
        String sql = getQueryDescriptor("formButtonTableName").getSql();
        return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
    }

    // 查询已经选择的数据模型
    @Override
    public  List<Map<String, Object>> querySelectedTableListByFormId(SafFormsQueryRequest queryRequest) {
        String sql= getQueryDescriptorForm("selectedTableData").getSql();
        List<Map<String, Object>> data = this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId());
        return data;

    }

    //保存自定义按钮
    @Override
    @Transactional
    public String saveCustomButton(FormButtons entity){
        List <FormButtons>list=formButtonsRepository.findByFormId(entity.getFormId());
        int zs=1;
        if (list!=null&&list.size()>0){
            zs=list.size()+1;
        }
        FormButtons formButtons=null;
        if (StringUtil.isBlank(entity.getId())){
              formButtons=new FormButtons();
              Utils.CopyBean(entity,formButtons);
              formButtons.setId(Utils.createUuid());
              formButtons.setFormId(entity.getFormId());
            //  formButtons.setButtonKey(btnValue);
            //  formButtons.setButtonName(btnName);
            // formButtons.setButtonMethodName(btnValue);
            // formButtons.setModelName();
               formButtons.setButtonType(2);
               formButtons.setStatus(1);
               formButtons.setSequence(zs);
        } else{
            formButtons = formButtonsRepository.findOne(entity.getId());
            formButtons.setTableName(entity.getTableName());
            formButtons.setButtonMethodName(entity.getButtonMethodName());
            formButtons.setButtonName(entity.getButtonName());
            formButtons.setButtonMethodContent(entity.getButtonMethodContent());

        }
        formButtonsRepository.save(formButtons);
        return entity.getId();
    }


}
