package com.huigou.uasp.form.application.impl;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;

import com.huigou.exception.ApplicationException;
import com.huigou.uasp.form.domain.model.*;
import com.huigou.uasp.form.repository.*;
import net.sf.ezmorph.bean.MorphDynaBean;
import oracle.net.aso.f;

import org.apache.commons.beanutils.DynaProperty;
import org.springframework.util.Assert;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
//import com.huigou.util.CommonUtil;
//import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
//import com.huigou.uasp.util.Utils;
import com.huigou.uasp.util.Constant;
import com.huigou.uasp.util.Utils;

import org.springframework.transaction.annotation.Transactional;

import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.bmp.configuration.domain.model.SysDictionary;
import com.huigou.uasp.bmp.configuration.repository.SysDictionaryRepository;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.data.repository.GeneralRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.application.FormsDesignApplication;
import com.huigou.uasp.form.application.SafFormslistApplication;
import com.huigou.uasp.form.domain.query.FormParameterQueryRequest;
import com.huigou.uasp.form.domain.query.FormsAttributeQueryRequest;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.pojo.Options;
import com.huigou.uasp.form.pojo.PubProperty;
import com.huigou.uasp.form.pojo.Root;
import com.huigou.uasp.form.pojo.TableColumns;
import com.huigou.uasp.meta.domain.model.MetaData;
import com.huigou.uasp.meta.repository.MetaDataRepository;
import com.huigou.uasp.model.domain.query.DbTablesQueryRequest;


@Service("formsDesignApplication")
public class FormsDesignApplicationImpl extends BaseApplication implements FormsDesignApplication {

	static String QUERY_XML_FILE_PATH = "config/formdesign/safFormslist.xml";
	private String pagePath = "/customform/";

	@Autowired
	private GeneralRepository generalRepository;

	@Autowired
	private SafFormslistRepository safFormslistRepository;

	@Autowired
	private FormAttributeRepository formAttributeRepository;

	@Autowired
	private  FormTablesRepository   formTablesRepository;

	@Autowired
	private FormParameterRepository formParameterRepository;

	@Autowired
	private FormSearchSqlRepository formSearchSqlRepository;
	@Autowired
	private  SysDictionaryRepository sysDictionaryRepository;
	@Autowired
	private  FormButtonsRepository  formButtonsRepository;
	@Autowired
	private CommonUtilApplication commonUtilApplication;


	private QueryDescriptor getQueryDescriptor(String entityName) {
		return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
	}

	@Override
	@Transactional
	public Map <String,Object> saveFormAttribute(FormsAttributeQueryRequest queryRequest,SafFormslist form) {
		Map <String, Object>map = new HashMap<String, Object>();
		map.put("success", "1");
		try {
			List <Root> rootList=queryRequest.getRootList();

			String mainTableName=queryRequest.getTableName();

			// List <FormAttribute> attrList=this.formAttributeRepository.findByFormIdAndType(form.getId(),1);  //主表属性
			form.setJson(queryRequest.getJson());
			this.safFormslistRepository.saveAndFlush(form);

			//删除主表单的属性配置
			this.formAttributeRepository.deleteFormAttributeByFormIdAndTableName(form.getId(),mainTableName);

			//获取主表所有字段元素
			List<Map<String, Object>> mainFieldLists=commonUtilApplication.queryFormTableFields(queryRequest.getFormNo(),mainTableName);
			List <String>displayNums=new ArrayList<String>();
			//删除表单定义的文件附件
			//  this.formParameterRepository.deleteFormParameter(form.getFormNo(),5);
			//遍历表单属性列表
			int sequence=0;
			for (Root root:rootList){
				// nums++;
				root.setFormId(form.getId());
				root.setFormNo(form.getFormNo());
				if ("1".equals(map.get("success").toString())) {
					if ("table".equals(root.getType())) {  // 无页签的明细表格列表 -->子表单

						map = saveTableAttribute(root, sequence);
						sequence = Integer.parseInt(map.get("sequence").toString());
					} else if ("tabs".equals(root.getType())) {  // 存在页签的 -->标签页

						map = saveTableAttribute(root, sequence);
						sequence = Integer.parseInt(map.get("sequence").toString());
					} else if ("grid".equals(root.getType())) {  //主表表单数据项  存在Grid的-->栅格布局

						map = saveFormAttribute(root, mainFieldLists, sequence);
						sequence = Integer.parseInt(map.get("sequence").toString());

					} else if (Constant.FILE_TAG.equals(root.getType())
							|| Constant.DIVIDER_TAG.equals(root.getType())
							|| Constant.TEXT_TAG.equals(root.getType())
							|| Constant.HTML_TAG.equals(root.getType())
					) { // 文件附件 或分割线  文字块
						sequence++;
						saveFormSingleAttribute(root, mainTableName, sequence);
					} else {  //其它组件 都归于主表数据
						map = saveFormAttribute(root, mainFieldLists, sequence);
						if ("1".equals(map.get("success").toString())) {
							sequence = Integer.parseInt(map.get("sequence").toString());
						}
					}

					if ("table".equals(root.getType()) || "grid".equals(root.getType())) {  //表格或表单
						if (root.getTableColumns().get(0).getTable() != null && !displayNums.contains(root.getTableColumns().get(0).getTable())) {
							displayNums.add(root.getTableColumns().get(0).getTable());//表名
						}
					}
				}
			}
			//保存表单及明细表的顺序
			List<FormTables> formTablesList=this.formTablesRepository.findByFormId(form.getId());
			for (int u=0;u<displayNums.size();u++){
				for (FormTables formTables:formTablesList){
					if (formTables.getTableName().equals(displayNums.get(u))){
						formTables.setDisplayNums(u+1);
						this.formTablesRepository.saveAndFlush(formTables);
						break;
					}
				}
			}

		} catch (Exception e) {
			map.put("success", "0");
			map.put("reason", e.getMessage());
			e.printStackTrace();
		}
		return map;
	}

	//保存主表的单个属性
	private void saveFormSingleAttribute(Root root,String mainTableName,int  sequence){
		FormAttribute formAttribute = new FormAttribute();
		formAttribute.setId(Utils.createUuid());
		formAttribute.setFormId(root.getFormId());
		formAttribute.setTableName(mainTableName);
		formAttribute.setTableType(1);

		formAttribute.setFieldTag(root.getType());
		formAttribute.setAttrName(root.getName());
		formAttribute.setAttrCode(root.getModel());
		formAttribute.setLabelCol(12);

		if (Constant.FILE_TAG.equals(root.getType())) {
			formAttribute.setAttrCode(root.getOptions().getBizCode());
			formAttribute.setMetaId(root.getOptions().getBizId());
		}
		if (Constant.TEXT_TAG.equals(root.getType())) {
			formAttribute.setFieldTag(Constant.LABEL_TAG);
			formAttribute.setDefaultValue(root.getOptions().getDefaultValue());
		}
		if (Constant.HTML_TAG.equals(root.getType())) {
			formAttribute.setFieldTag(Constant.HTML_TAG);
			formAttribute.setDefaultValue(root.getOptions().getDefaultValue());
		}
		formAttribute.setWidth(0);
		formAttribute.setDataFormat("");
		formAttribute.setMustInput(0);
		formAttribute.setStatus(1);
		formAttribute.setFieldCol(0);
		formAttribute.setTextareaRow(0);
		formAttribute.setSequence(sequence);
		formAttribute.setTabLabel(root.getTabLabel());
		formAttribute.setCreatedDate(new Date());
		this.formAttributeRepository.save(formAttribute);
	}

	//保存主表表单属性
	private Map <String,Object>  saveFormAttribute(Root root,List<Map<String, Object>> fieldLists,int  sequence){
		Map <String, Object>map = new HashMap<String, Object>();
		map.put("success", "1");
		map.put("reason","");
		map.put("sequence",sequence);

		List <TableColumns>tableList=root.getTableColumns();
		int tableType=1;
		PubProperty property=null;
		try{
			boolean repeatfield = false;
			if (tableList==null){  //不是在Grid中添加的表单标签 默认为主表单的内容
				sequence++;
				property=new PubProperty();
				property.setCols(1);
				Utils.CopyBean(root, property);

				if (root.getOptions().getLabelWidth()==100){
					property.setLabelCol(2);
				}
				if (root.getOptions().getLabelWidth()<100){
					property.setLabelCol(1);
				}
				if (root.getOptions().getLabelWidth()>100){
					property.setLabelCol(3);
				}
				property.setFieldCol(Constant.TAG_MAXCOLS-property.getLabelCol());
				property.setDefaultValue(root.getOptions().getDefaultValue());
				// property.setGroupLabel(root.getModel());
				List  <FormAttribute>list=this.formAttributeRepository.findByFormIdAndTable(root.getFormId(),root.getTable());
				for (FormAttribute formAttribute:list){
					if (formAttribute.getAttrCode().equals(root.getModel())){
						repeatfield=true;
						break;
					}
				}
				if (repeatfield) {
					map.put("success", "0");
					map.put("reason", "表单存在重复定义字段!"+root.getModel());
					//throw new ApplicationException("表单存在重复定义字段!")
				} else {
					map = saveAttributeDetail(property, fieldLists, tableType, sequence);
				}
			} else {
				if (tableList.size() > Constant.PAGEDETAIL_COLS) {
					//throw new ApplicationException("每行标签元素个数不能大于"+Constant.PAGEDETAIL_COLS);
					//map.put("success", "0");
					// map.put("reason","每行标签元素个数不能大于"+Constant.PAGEDETAIL_COLS);
				}
				//计算每个标签占用的列数
				int allSpan = 0;
				for (TableColumns tableColumns : tableList) {
					allSpan += Integer.parseInt(tableColumns.getSpan());
				}

				for (int u = 0; u < tableList.size(); u++) {
					String field = tableList.get(u).getModel();
					for (int j = u + 1; j < tableList.size(); j++) {
						if (field.equals(tableList.get(j).getModel())) {
							repeatfield = true;
							break;
						}
					}
				}
				if (repeatfield) {
					map.put("success", "0");
					map.put("reason", "表单存在重复定义字段!");
					//throw new ApplicationException("表单存在重复定义字段!");
				} else {

					for (TableColumns tableColumns : tableList) {
						sequence++;
						property = new PubProperty();
						Utils.CopyBean(tableColumns, property);
						property.setFormId(root.getFormId());
						property.setFormNo(root.getFormNo());
						property.setCols(tableList.size());
						property.setDefaultValue(tableColumns.getOptions().getDefaultValue());
						// tableColumns.getOptions().getPlaceholder(); //占位内容
						if (tableColumns.getOptions().getLabelWidth() == 100) {
							property.setLabelCol(2);
						}
						if (tableColumns.getOptions().getLabelWidth() < 100) {
							property.setLabelCol(1);
						}
						if (tableColumns.getOptions().getLabelWidth() > 100) {
							property.setLabelCol(3);
						}
						countTagElementCols(property, tableList.size(), allSpan, tableColumns.getSpan());
						// property.setGroupLabel(root.getModel());

						if ("button".equals(tableColumns.getType())) {
							map = saveTableButtons(property, sequence);
						} else {
							map = saveAttributeDetail(property, fieldLists, tableType, sequence);
						}

					}
				}
				map.put("sequence", sequence);
			}
		} catch (Exception e) {
			map.put("success", "0");
			map.put("reason", e.getMessage());
			e.printStackTrace();
		}
		return map;
	}

	private void countTagElementCols(PubProperty property,int cols,int allSpan,String span){
		//property.setLabelCol(2);
		if (allSpan/cols==Integer.parseInt(span)) {   //平均分配列数
			if (cols >= 5) {
				property.setLabelCol(1);
				property.setFieldCol(1);
			} else {
				if (cols == 4) {
					property.setLabelCol(1);
				}
				property.setFieldCol((Constant.TAG_MAXCOLS- cols * property.getLabelCol()) / cols);
			}
		} else { //重新计算所占列数
			//int  curSpan=10*Integer.parseInt(span)/allSpan;
			int u=Constant.TAG_MAXCOLS/cols+(Integer.parseInt(span)-Constant.TAG_MAXCOLS)/2;
			property.setFieldCol(u-property.getLabelCol());
		}
	}

	//保存明细表前面的按钮
	private Map<String,Object>  saveTableButtons(PubProperty pubProperty,int sequence){
		Map <String, Object>map = new HashMap<String, Object>();
		map.put("success", "1");
		map.put("reason","");
		//	List <TableColumns>tableList=root.getTableColumns();
		//	List<Map<String, Object>>  fieldLists=new ArrayList<Map<String, Object>>();
		int tableType=2;
		int s=0;
		try{
			PubProperty property=null;

			//遍历按钮列表
			int k=0;
			FormButtons formButtons=null;
			//for (TableColumns tableColumn:btnList){
			//	k++;
			this.formButtonsRepository.deleteFormButtonsByKeyAndType(pubProperty.getFormId(),pubProperty.getModel(),3);
			formButtons=new FormButtons();
			formButtons.setFormId(pubProperty.getFormId());
			formButtons.setButtonName(pubProperty.getName());
			// formButtons.setButtonMethodName(tableColumn.getModel());
			formButtons.setTabLabel(pubProperty.getTabLabel());
			formButtons.setButtonKey(pubProperty.getModel());
			//	formButtons.setGroupLabel(pubProperty.getGroupLabel());
			formButtons.setButtonType(3);
			formButtons.setSequence(sequence);
			formButtons.setStatus(1);
			this.formButtonsRepository.save(formButtons);
			//	}
		} catch (Exception e) {
			map.put("success", "0");
			map.put("reason", e.getMessage());
			e.printStackTrace();
		}
		return map;
	}

	//保存明细表格的属性
	private Map <String,Object>  saveTableAttribute(Root root,int sequence){
		Map <String, Object>map = new HashMap<String, Object>();
		map.put("success", "1");
		map.put("reason","");
		List <TableColumns>tableList=root.getTableColumns();
		List<Map<String, Object>>  fieldLists=new ArrayList<Map<String, Object>>();
		int tableType=2;
		//  int s=0;
		try{
			PubProperty property=null;

			//取出其中多个存在多个页签的 其中有按钮 列表等
			List <TableColumns> newTableList=new ArrayList<>();
			List <TableColumns> btnList=new ArrayList<>();
			List <String> tables=new  ArrayList<String>();
			String tableStr="";
			for (TableColumns tableColumn:tableList){   //剔除非表字段元素 比如按钮等
				if (tableColumn.getTabLabel()!=null){   //有页签的
					if (tableColumn.getTable()!=null){ //有表名的
						newTableList.add(tableColumn);
						tableStr=tableColumn.getTable()+","+tableColumn.getPartype();
						if (tableColumn.getTabLabel()!=null){
							tableStr+=","+tableColumn.getTabLabel();
						}
						tables.add(tableStr);
					} else if ("button".equals(tableColumn.getType())){
						btnList.add(tableColumn);
					}
				} else {
					newTableList.add(tableColumn);
					tableStr=tableColumn.getTable()+","+tableColumn.getPartype();
					if (tableColumn.getTabLabel()!=null){
						tableStr+=","+tableColumn.getTabLabel();
					}
					tables.add(tableStr);
				}
			}

			List<String> distinctTables = tables.stream().distinct().collect(Collectors.toList());
			if (newTableList!=null&&newTableList.size()>0) {
				for (String table : distinctTables) {
					String[] str = table.split(",");
					fieldLists.addAll(commonUtilApplication.queryFormTableFields(root.getFormNo(), str[0]));
					//删除明细表单的配置  先判断是否明细表  因为存在主表属性任意 放在明细表后面
					if (this.formTablesRepository.findByFormIdAndTableName(root.getFormId(),str[0]).get(0).getTableType()==2) {
						this.formAttributeRepository.deleteFormAttributeByFormIdAndTableName(root.getFormId(), str[0]);
					}
				}
			}

			//遍历按钮列表
			int k=0;
			FormButtons formButtons=null;
			for (TableColumns tableColumn:btnList){
				k++;
				this.formButtonsRepository.deleteFormButtonsByKeyAndType(root.getFormId(),tableColumn.getModel(),3);
				formButtons=new FormButtons();
				formButtons.setFormId(root.getFormId());
				formButtons.setButtonName(tableColumn.getName());
				// formButtons.setButtonMethodName(tableColumn.getModel());
				formButtons.setTabLabel(tableColumn.getTabLabel());
				formButtons.setButtonKey(tableColumn.getModel());
				//formButtons.setGroupLabel(root.getModel());
				formButtons.setButtonType(3);
				formButtons.setSequence(k);
				formButtons.setStatus(1);
				this.formButtonsRepository.save(formButtons);

			}
			//List<FormTables> collect = tables.stream().distinct().collect(Collectors.toList());
			for (String table:distinctTables) {
				String []str=table.split(",");
				if (!"".equals(str[0])) {
					List<FormTables> tablist = this.formTablesRepository.findByFormIdAndTableName(root.getFormId(),str[0]);
					FormTables formTables = tablist.get(0);
					if (str.length>1) {
						formTables.setDisplayMode(str[1]);}
					if (str.length>2) {
						formTables.setTabLabel(str[2]);
					}
					formTables.setSubTableTitle(root.getName());
					this.formTablesRepository.saveAndFlush(formTables);
				}
			}

			for (TableColumns tableColumns:newTableList){
				sequence++;
				property=new PubProperty();
				Utils.CopyBean(tableColumns, property);
				property.setFormId(root.getFormId());
				property.setFormNo(root.getFormNo());
				//  property.setGroupLabel(root.getModel());
				int width=Integer.parseInt(tableColumns.getOptions().getWidth().replace("px",""));
				property.setWidth(width);
				map=saveAttributeDetail(property,fieldLists,tableType,sequence);
			}
			map.put("sequence",sequence);
		} catch (Exception e) {
			map.put("success", "0");
			map.put("reason", e.getMessage());
			e.printStackTrace();
		}
		return map;
	}

	//保存标签详细属性
	private  Map <String,Object> saveAttributeDetail(PubProperty root,List<Map<String, Object>> fieldLists,int tableType,int sequence){
		Map <String, Object>map = new HashMap<String, Object>();
		map.put("success", "1");
		String reason="";
		try{
			// int  cols=root.getCols();
			FormAttribute formAttribute = new FormAttribute();
			formAttribute.setId(Utils.createUuid());
			formAttribute.setFormId(root.getFormId());
			formAttribute.setTableName(root.getTable());
			formAttribute.setTableType(tableType);
			formAttribute.setAttrCode(root.getModel());
			formAttribute.setAttrName(root.getName());
			formAttribute.setTabLabel(root.getTabLabel());
			if (!Constant.EASYSEARCH_TAG.equals(root.getType())){
				formAttribute.setDefaultValue(root.getDefaultValue());
			}
			if (root.getOptions().getPattern()!=null){
				formAttribute.setJsFunction(root.getOptions().getPattern());
				formAttribute.setRemark(root.getOptions().getPatternMessage());
			}
			formAttribute.setLabelCol(root.getLabelCol());
			formAttribute.setFieldCol(root.getFieldCol());
			formAttribute.setWidth(root.getWidth());
			formAttribute.setTextareaRow(0);

			Map <String,Object>fieldMap=null;

			String metaId="";
			for (int x=0;x<fieldLists.size();x++) {
				fieldMap=fieldLists.get(x);
				if (root.getModel().equals(fieldMap.get("fieldCode").toString())){
					metaId=fieldMap.get("id").toString();
					break;
				}
			}
			formAttribute.setMetaId(metaId);
			if (root.getOptions().getDisabled()){
				formAttribute.setDefaultOperation("readonly");
			}
			if (root.getOptions().getFormat()!=null) {
				if (Constant.DATE_TAG.equals(root.getType())) {
					formAttribute.setDataFormat(root.getType());
				} else {
					formAttribute.setDataFormat(root.getOptions().getFormat());
				}
			}else  if ("number".equals(fieldMap.get("fieldDataType").toString())){ //字段是数值型
				formAttribute.setDataFormat("number");
			} else {
				formAttribute.setDataFormat("string");
			}
			formAttribute.setStatus(1);
			formAttribute.setFieldTag(root.getType());

			if (Constant.INPUT_TAG.equals(root.getType())){  //input -->text
				formAttribute.setFieldTag(Constant.TEXT_TAG);
			}
			if ("number".equals(root.getType())){
				formAttribute.setFieldTag(Constant.SPINNER_TAG);
				formAttribute.setDataFormat("number");
			}
			//  if  (Constant.TEXT_TAG.equals(root.getType())){// text -->label
			//	  formAttribute.setFieldTag(Constant.LABEL_TAG);
			//	  formAttribute.setDefaultValue(root.getOptions().getDefaultValue());
			//  }
			if (Constant.TEXTAREA_TAG.equals(root.getType())){
				formAttribute.setTextareaRow(Constant.TEXTAREA_ROWS);
			}
			if (Constant.SELECT_TAG.equals(root.getType())){
				String dataSourceType=Constant.DATASOURCETYPE_NO;
				// if (root.getOptions().getDataType()!=null&&!"".equals(root.getOptions().getDataType())){
				//	 dataSourceType=root.getOptions().getDataType();
				// }
				//固定值
				List <MorphDynaBean>optionbeans= (List <MorphDynaBean>)root.getOptions().getOptions();
				if (optionbeans.size()>0 ){
					dataSourceType=Constant.DATASOURCETYPE_FIX;
				} else {
					if (root.getOptions().getDictionary()!=null&&!"".equals(root.getOptions().getDictionary())){
						dataSourceType=Constant.DATASOURCETYPE_DICT;
						formAttribute.setDataSource(root.getOptions().getDictionary());
					}
				}
				formAttribute.setDataSourceType(dataSourceType);
				getSelectDataSource(formAttribute,optionbeans);
			}
			if  (Constant.CHECKBOX_TAG.equals(root.getType())||Constant.RADIOS_TAG.equals(root.getType())){

				String dataSourceType=Constant.DATASOURCETYPE_FIX;//默认是自定义的数据
				List <MorphDynaBean>optionbeans= (List <MorphDynaBean>)root.getOptions().getOptions();
				if (optionbeans.size()>0 ) {
					dataSourceType = Constant.DATASOURCETYPE_FIX;
					getSelectDataSource(formAttribute,optionbeans);
				} else {
					if (root.getOptions().getDictionary() != null && !"".equals(root.getOptions().getDictionary())) {
						dataSourceType = Constant.DATASOURCETYPE_DICT;
						formAttribute.setDataSource(root.getOptions().getDictionary());
					}
				}
				formAttribute.setDataSourceType(dataSourceType);
			}
			if (Constant.EASYSEARCH_TAG.equals(root.getType())){
				Options option=(Options)root.getOptions();
				List <MorphDynaBean>optionbeans= option.getOptions();//(List <MorphDynaBean>)(Options)root.getOptions();
				DynaProperty[] tabdynaProperties=null;
				Object attrVal=null;
				String attrName="";

				MorphDynaBean tabbean=optionbeans.get(1);  //位于第二个   Treebox位于第一个
				// object=new TableColumns();
				tabdynaProperties = tabbean.getDynaClass().getDynaProperties();
				attrName = tabdynaProperties[0].getName();//属性名称 第一个是options
				//attrVal = tabbean.get(attrName);//属性值
				List <MorphDynaBean>querybeans=(List <MorphDynaBean>)tabbean.get(attrName);
				attrVal=((MorphDynaBean)querybeans.get(0)).get("queryName");

				//  System.out.println(attrName+"==yy==="+attrVal);
				formAttribute.setDataSource(attrVal.toString());
				formAttribute.setDataSourceType(Constant.DATASOURCETYPE_SQL);  //
				formAttribute.setFieldTag(Constant.SELECT_TAG);

				//更新SAF_FORM_SEARCH_SQL
				List <FormSearchSql> slist=this.formSearchSqlRepository.searchSqlByFormNoAndSearchName(root.getFormNo(),attrVal.toString());
				if  (slist!=null&&slist.size()>0){
					FormSearchSql formSearchSql=slist.get(0);
					formSearchSql.setTargetField(root.getModel()); //设置关联字段
					formSearchSql.setTableName(root.getTable());
					formSearchSql.setCreatedDate(new Date());
					this.formSearchSqlRepository.saveAndFlush(formSearchSql);
				}

			}

			if (root.getOptions().getCustomClass()!=null){  //增加样式
				formAttribute.setCssStyle(root.getOptions().getCustomClass());
			}
			formAttribute.setMustInput(root.getOptions().getRequired()?1:0);
			if (root.getOptions().getRequired()) {
				formAttribute.setRemark(root.getOptions().getRequiredMessage());
			}

			if (tableType==1){ //主表字段  台账默认都显示
				formAttribute.setDisplayListing(1);
			}
			formAttribute.setSequence(sequence);
			formAttribute.setCreatedDate(new Date());

			if (!"".equals(metaId)){ //字段存在 才保存
				this.formAttributeRepository.save(formAttribute);
			} else {
				if ("".equals(reason)){
					reason="没有找到字段:"+root.getModel();
				} else {
					reason+=root.getModel()+",";
				}
				System.out.println("没有找到字段:"+root.getModel());
			}
			map.put("reason",reason);
		} catch (Exception e) {
			map.put("success", "0");
			map.put("reason", e.getMessage());
			e.printStackTrace();
		}
		return map;

	}

	@Override
	public String getUserDictFolderIds(String dictName) {
		StringBuffer sb=new StringBuffer();
		sb=sb.append("select id from SA_CommonTree t start with name = '").append(dictName).append("' connect by t.parent_id= prior id");
		String sql = sb.toString();
		List<String> ids = this.sqlExecutorDao.queryToList(sql, String.class, null);
		String resultIds = String.join(",", ids);
		return resultIds;
	}

	private void getSelectDataSource(FormAttribute formAttribute,List <MorphDynaBean>optionbeans){
		DynaProperty[] tabdynaProperties=null;
		JSONObject backData = new JSONObject();
		String key="",val="";
		Object  attrVal =null;
		String  attrName ="";int k=1;
		for (MorphDynaBean tbeans:optionbeans){
			tabdynaProperties = tbeans.getDynaClass().getDynaProperties();
			for(int m=0; m<tabdynaProperties.length;m++) {
				attrName = tabdynaProperties[m].getName();//属性名称 第一个是options
				attrVal = tbeans.get(attrName);//属性值      checkbox 只有 value ？
				// System.out.println(attrName + "===attrVal====" + attrVal.toString().trim());
				if (attrVal != null) {
					if ("label".equals(attrName)) {  //radio返回label value;checkbox 只有 value
						key = attrVal.toString().trim();
					} else {
						val = attrVal.toString().trim();
					}
				}

				//if ("".equals(key)) { //checkbox返回没有label
				key = String.valueOf(k);
				//}
				backData.put(key, val);
				k++;
			}
			formAttribute.setDataSource(backData.toJSONString());
		}
	}

	//查询表单的数据字典
	@Override
	public List <Map <String,Object>>  getFormDataDict(String dictName){
		String folderId=getUserDictFolderIds(dictName);
		String sql="select a.code,a.name from sa_dictionary a where a.folder_id='"+folderId+"'";
		List<Map <String,Object>> data = this.sqlExecutorDao.queryToListMap(sql,null);
		return data;
	}

	//获取数据库中所有的函数或过程
	@Override
	public List <Map <String,Object>>  getDBFunctionsOrProceduce(String type,String formNo){
		String sql = getQueryDescriptor("queryFormFunctionOrProcduce").getSql();
		return this.sqlExecutorDao.queryToListMap(sql,type,formNo+"%");
	}

	//获取组织机构中的组织和部门类型数据
	@Override
	public List <Map <String,Object>>  getOrgOrDepts(String org) {
		String sql = "select a.id,a.org_name||'/'||a.dept_name  org  from sa_oporg a where a.org_kind_id='ogn' or a.org_kind_id ='dpt'";
		List<Map<String, Object>> data = this.sqlExecutorDao.queryToListMap(sql, null);
		return data;
	}
}
