package com.huigou.uasp.form.application.impl;

import com.huigou.context.Operator;
import com.huigou.context.ThreadLocalUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.data.domain.query.DataRecordQueryRequest;
import com.huigou.uasp.form.application.DataPermissionApplication;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("dataPermissionApplication")
public class DataPermissionApplicationImpl extends BaseApplication implements DataPermissionApplication {

    static String QUERY_XML_FILE_PATH = "config/formdesign/dataPermissions.xml";

    private QueryDescriptor getQueryDescriptor(String entityName) {
        return this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, entityName);
    }

    public  List<Map<String, Object>> queryDataManageTypes(SafFormsQueryRequest queryRequest){
        String sql = getQueryDescriptor("queryDataManageTypes").getSql();
        return this.sqlExecutorDao.queryToListMap(sql,queryRequest.getFormNo());

    }
    public  List<Map<String, Object>> queryDataManagePermissions(DataRecordQueryRequest queryRequest){
        String sql = getQueryDescriptor("queryDataManagePermissions").getSql();
        Operator operator = ThreadLocalUtil.getOperator();
        return this.sqlExecutorDao.queryToListMap(sql,operator.getPersonMemberId(),queryRequest.getFormNo());

    }

    public  List<Map<String, Object>> queryDataManagePermissionDetail(String dataManagedetalId){
        String sql = getQueryDescriptor("queryDataManagePermissionDetail").getSql();
        return this.sqlExecutorDao.queryToListMap(sql,dataManagedetalId);

    }
    public  List<Map<String, Object>> queryDataManagePermissionFields(String dataManageId,String dataKindCode){
        String sql = getQueryDescriptor("queryDataManagePermissionFields").getSql();
        return this.sqlExecutorDao.queryToListMap(sql,dataManageId,dataKindCode);

    }

    public  List<Map<String, Object>> queryDataManageBussinessFields(String dataManageId,String dataKind){
        String sql = getQueryDescriptor("queryDataManageBussinessFields").getSql();
        return this.sqlExecutorDao.queryToListMap(sql,dataManageId,dataKind);

    }


    //获取当前表单的和当前用户的数据管理权限
    public void getDataManagePermission(DataRecordQueryRequest queryRequest,StringBuffer sb){
        List <Map<String,Object>>listdatas=this.queryDataManagePermissions(queryRequest);
        listdatas.forEach((o) -> {	getDataPermission(sb,o);});
    }

    public void getDataPermission(StringBuffer sb,Map map){

        List<Map<String, Object>> permissions=permissions = this.queryDataManagePermissionDetail(map.get("dataManagedetalId").toString());
        switch(map.get("dataKind").toString())
        {
            case "org":
                sb.append(getOrgConditions(permissions));
                break;

            case "dictionary":
                sb.append(getDictionaryConditions(permissions,map.get("dataManageId").toString(),map.get("dataKindCode").toString()));
                break;

            case "enum":
                sb.append(getEnumConditions(permissions,map.get("dataManageId").toString(),map.get("dataKind").toString()));
                break;

            case "define":
                //sb=new StringBuffer("");
               // List<Map<String, Object>> bussinessFields = this.queryDataManageBussinessFields(map.get("dataManageId").toString(),map.get("dataKind").toString());
                String sql="";
                break;

            case "input":
                //sb=new StringBuffer("");
                //List<Map<String, Object>> bussinessFields2 = this.queryDataManageBussinessFields(map.get("dataManageId").toString(),map.get("dataKind").toString());
                String sql2="";
                break;

            default:
        }
    }

    public  String  getOrgConditions(List<Map<String, Object>> permissions){
        Operator operator = ThreadLocalUtil.getOperator();
        String sql="";
        if (permissions.size() > 0) {
            sql = " and (";
            for (int k = 0; k < permissions.size(); k++) {
                Map map = permissions.get(k);
                //if ("org".equals(map.get("dataKind").toString())) {  //是组织机构
                sql += " t.full_id like '%" + map.get("resourceKey").toString() + "%'";
                if (k < permissions.size() - 1) {
                    sql += " or ";
                }
                //}
            }
            sql += " or t.full_id like '%" + operator.getPersonMemberId() + "%'";  //允许查看自己的
            sql += ")";
            if (sql.length() < 10) {
                sql = "";
            }
        } else {
            sql = " or  t.full_id like '%" + operator.getPersonMemberId() + "%'";
        }
        return  sql;
    }



public String getDictionaryConditions(List<Map<String, Object>> permissions,String dataManageId,String dataKindCode){

        List<Map<String, Object>> permissionFields=this.queryDataManagePermissionFields(dataManageId,dataKindCode);
        String sql=" and (t.";
        Map map=permissionFields.get(0);
        //and f.table_column and f.column_data_type  and f.column_symbol
        sql+=map.get("tableColumn").toString();
        if (permissions.size() > 0) {
            if (permissions.size()>1){  //多个值 ，换成in
                sql+=" in (";
            } else {
                sql+=map.get("columnSymbol").toString();
            }
            for (int k = 0; k < permissions.size(); k++) {
                Map maps = permissions.get(k);
                if (map.get("columnDataType").toString().indexOf("String")>0
                        ||map.get("columnDataType").toString().indexOf("Date")>0
                ) {   //Integer   Long  Bigdecimal
                    sql += "'"+maps.get("resourceKey").toString()+"'";
                }  else if (map.get("columnDataType").toString().indexOf("Integer")>0
                        ||map.get("columnDataType").toString().indexOf("Long")>0
                        ||map.get("columnDataType").toString().indexOf("Bigdecimal")>0
                ) {   //Integer   Long  Bigdecimal
                    sql += maps.get("resourceKey").toString();
                }
                if (k<permissions.size()-1){
                    sql+=",";
                }
            }
            if (permissions.size()>1){  //多个值 ，换成in
                sql+=" ) ";
            }
            sql+=")";
        }
        return sql;
    }
    //枚举条件in ('','')   定义时格式,,
    public String getEnumConditions(List<Map<String, Object>> permissions,String dataManageId,String dataKindCode){

        List<Map<String, Object>> bussinessFields = this.queryDataManageBussinessFields(dataManageId,dataKindCode);
        String sql=" and  (t.";
        Map map=bussinessFields.get(0);

        sql+=map.get("tableColumn").toString();
        sql+=" "+map.get("columnSymbol").toString()+" (";
        if (bussinessFields.size()>0){
            for (int k = 0; k < bussinessFields.size(); k++) {
                Map maps = bussinessFields.get(k);
                String dataVals=maps.get("dataSource").toString();
                // dataVals=dataVals.replaceAll("{","");
                // dataVals=dataVals.replaceAll("}","");
                String []dataval=dataVals.split(",");
                for (int n = 0; n <dataval.length;n++) {
                    if (map.get("columnDataType").toString().indexOf("String") > 0
                            || map.get("columnDataType").toString().indexOf("Date") > 0
                    ) {   //Integer   Long  Bigdecimal
                        sql += "'" + dataval[n] + "'";
                    } else if (map.get("columnDataType").toString().indexOf("Integer") > 0
                            || map.get("columnDataType").toString().indexOf("Long") > 0
                            || map.get("columnDataType").toString().indexOf("Bigdecimal") > 0
                    ) {   //Integer   Long  Bigdecimal
                        sql +=  dataval[n];
                    }
                    if (n<dataval.length-1){
                        sql += ",";
                    }
                }
            }
            sql+="))";
        }
        return sql;

    }

    public String getDefineConditions(List<Map<String, Object>> permissions,String dataManageId,String dataKindCode){
        return "";
    }
    public String getInputConditions(List<Map<String, Object>> permissions,String dataManageId,String dataKindCode){
        return "";
    }

    @Override
    public List<Map<String, Object>> queryUIElementFields(SafFormsQueryRequest queryRequest) {
        //SafFormslist safFormslist=this.safFormslistRepository.findOne(queryRequest.getId());
        String sql = getQueryDescriptor("searchUIElementFields").getSql();
        return this.sqlExecutorDao.queryToListMap(sql, queryRequest.getId(), queryRequest.getId());
    }

   /* List<Strudent> list = new ArrayList<Strudent>();
    list.stream().filter(student -> {
        student.getAge() < 20
    }).forEach(
            System.out.println(student.toString());
   });
   List<String> list = java.util.Arrays.asList("a","b","c");

        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {

            System.out.println(String.valueOf(i) + list.get(i));

        });
         items.stream().filter(s->s.equals("C")).forEach(System.out::println);

         	List<Map<String,Object>> temp_datas = datas.stream()
	 						.sorted(CommonUtil.CommonMapComparator.getInstance(sortColumn, CommonUtil.CommonMapComparator.INT_TYPE))
	 						.collect(Collectors.toList());
   */
}
