package com.huigou.uasp.data.controller;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.huigou.exception.ApplicationException;
import com.huigou.uasp.bpm.managment.domain.model.ProcDefinition;
import com.huigou.uasp.bpm.managment.repository.ProcDefinitionRespository;
import com.huigou.uasp.form.application.SafFormslistApplication;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.builder.vo.ParamFormVO;
import com.huigou.uasp.builder.vo.PubDataRecord;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.domain.model.FormTables;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.uasp.data.application.DataRecordApplication;
import com.huigou.uasp.data.domain.query.DataRecordQueryRequest;
import com.huigou.util.SDO;

@Controller
@ControllerMapping( "menuManage" ) 
public class MenuManageController  extends CommonController{ 

	@Autowired
	private  SafFormslistRepository safFormslistRepository;
	
	//@Autowired
	//private  FormTablesRepository formTablesRepository;
	
	//@Autowired
	//private  DataRecordApplication dataRecordApplication;
	
	@Autowired
	private  CommonUtilApplication  commonUtilApplication;

	@Autowired
	private SafFormslistApplication safFormsApplication;

	//@Autowired
	//private ProcDefinitionRespository procDefinitionRespository;

	@Override
	protected String getPagePath(){
		return "/customform/";
	}
	
	public String forwardPageList() throws IOException {
			SDO sdo = this.getSDO(); 
		  String olddata="0";
		   if ("1".equals(sdo.getString("olddata"))){
		    	olddata="1";
		  } 
		  String formNo=sdo.getString("formNo");
		  List <SafFormslist>list=safFormslistRepository.findByFormNo(formNo);
		  String pageName ="";
		 if (list.size()==0){
		 	throw new ApplicationException("表单已经不存在！");
		 } else {
			 SafFormslist safFormslist = list.get(0);

			 String tableName = commonUtilApplication.getTablesByFormId(safFormslist.getId(), 1);
			 if ("".equals(tableName)){
				 throw new ApplicationException("缺少数据模型！");
			 }
			 tableName = tableName.split(",")[0];  //取第一个主表

			 pageName = "/" + formNo + "/" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName) + "List";

			 this.putAttribute("formNo", formNo);

			 this.putAttribute("procId", commonUtilApplication.getProcDefinitionByFormNo(formNo));
		 }
		String webPath = this.getClass().getClassLoader().getResource("/").getPath();
		String osName = System.getProperty("os.name").toLowerCase();
		 if (osName.contains("windows") ){
			webPath=webPath.substring(1);
		}
		webPath = webPath.substring(0, webPath.length() - 16);
		webPath +=getPagePath()+pageName+".jsp";
		File file=new File(webPath);
		if (!file.exists()){
			return forward("../formdesign/errorPage");
		} else {
			return forward(pageName);
		}
	}


	/**
	 * 生成菜单基本信息
	 * @return
	 */
	public String produceMenuList(){
		SDO sdo = getSDO();
		SafFormsQueryRequest queryRequest = sdo.toQueryRequest(SafFormsQueryRequest.class);
		Map<String, Object> data =this.safFormsApplication.produceMenuList(queryRequest);
		return this.toResult(data);
	}
		
	
}
