package com.huigou.uasp.data.application;

import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

import com.huigou.uasp.builder.vo.PubDataRecord;
import com.huigou.uasp.data.domain.query.DataRecordQueryRequest;
import com.huigou.uasp.data.domain.query.MenuManageQueryRequest;


public interface DataRecordApplication {

	
	  /*
     * 加载单条数据
     * @see
     */
     PubDataRecord loadDataRecord(DataRecordQueryRequest queryRequest);
	
     /*
	     * 新增数据 加载初始化信息  初始化编码等信息
	     * @see
	     */
	 PubDataRecord loadDataRecordByAdded(DataRecordQueryRequest queryRequest) ;
	
	//保存实体
	 String  saveDataRecord(DataRecordQueryRequest queryRequest,Map<String, Object> datamap );
	 
	/**
	 * 查询数据 
	 * @param queryRequest
	 * @return
	 */
	Map<String, Object> queryDataRecord(DataRecordQueryRequest queryRequest);
	
	
	 //删除实体数据
    public void deleteDataRecord(DataRecordQueryRequest queryRequest, List<String> ids);
    
    
    //判断表是否存在
    int queryIsExistTable(DataRecordQueryRequest queryRequest);
    
    //查询明细表数据
    Map<String, Object> queryDataRecordDetail(DataRecordQueryRequest queryRequest);
    
    //保存行明细数据
	Map<String, Object>  saveRowDataRecordDetail(String formId,String mid,String subTable, List<PubDataRecord> detailData);
	//保存明细数据
	Map<String,Object> saveDataRecordDetail(DataRecordQueryRequest queryRequest, List <String> hiddenFieldList,List<PubDataRecord> detailData);
    
     //查询明细表中 检索SQL返回的隐藏字段  
     List<Map<String, Object>> queryHiddenFieldBySearchSQL(DataRecordQueryRequest queryRequest);
     
     ////改变状态
	 String changeDataRecordStatus(DataRecordQueryRequest queryRequest);

	//获取单条数据
	public  List<?> getSingDatasByID(DataRecordQueryRequest queryRequest);

	////改变明细表的状态
	 String changeDataRecordDetailStatus(DataRecordQueryRequest queryRequest);
	 
	 
	//删除明细数据
	 void deleteDataRecordDetail(DataRecordQueryRequest queryRequest, String ids);
	 
	 //效验函数方法
	 String checkFieldFunction(Map <String,Object> map);
	 
	  //如果配置了存储过程方式,调用主表存储过程处理 
	  String  callMainProcedure(String procName,String tableName,String id);
	 
	//如果配置了存储过程方式,调用明细表存储过程处理 
	 String callDetailProcedure(String subTable,String parentId,String id);
}
