package com.huigou.uasp.builder.filer;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.vo.ParamFormVO;

import com.huigou.uasp.util.Utils;

@Service("buildQueryFile")
public class BuildQueryRequestFile implements BuildFilerInter {
	
	@Override
	public String generateFile(ParamFormVO paraForm,List<Map<String, Object>> fieldList)  throws Exception{ 
		  File file=new File(paraForm.getSrcPath()+"/domain");
		  if (!file.exists()){
			  file.mkdir();
		  }
			  file=new File(paraForm.getSrcPath()+"/domain/query");
	      if (!file.exists()){
			  file.mkdir();
		  }
		  
		 String clsName= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,paraForm.getTableName());
		  clsName=Utils.toUpperCaseFirstOne(clsName);
		  clsName+="QueryRequest";
		  
		  String []searchFields=paraForm.getSearchFields();
		  String []fieldEns=paraForm.getFieldEns();
		  String []validatorTypes=paraForm.getValidatorTypes();
		  String []fieldTags=paraForm.getFieldTags();
		  String dataType="String",searchField="";
		    StringBuffer sb=new StringBuffer("");
		 try {
				sb.append("package ").append(paraForm.getPackageName()).append(".domain.query;\r\n ");
			    sb.append("	import com.huigou.data.domain.query.CodeAndNameQueryRequest;\r\n");
			    sb.append("	import java.util.Date;\r\n");
			    sb.append("\r\n");
			   	sb.append("public class "+clsName+" extends CodeAndNameQueryRequest{ \r\n ");
			    sb.append(" \r\n");
				sb.append("  private String id;\r\n ");
				sb.append("  public String getId() {\r\n ");
				sb.append("	return id;\r\n").append("}\r\n");

	 			sb.append("public void setId(String id) {\r\n ");
			    sb.append("	this.id = id;\r\n").append(" }\r\n");
			    sb.append(" \r\n");
			    
               if (searchFields.length>0){
			     for (int i=0;i<searchFields.length;i++){
			    	     dataType="String";
			    	if ("1".equals(searchFields[i])){ //
			    		 searchField=fieldEns[i]; 
			    		if (validatorTypes.length>i){
						    dataType=Utils.toUpperCaseFirstOne(validatorTypes[i]);
			    		  if ("number".equals(validatorTypes[i])){
							 dataType="Integer"; // 
						  }
						  if ("money".equals(validatorTypes[i])){ //是金额money型 转为Double
							 dataType="Double"; 
						  }
			    	    }
					  if ("date".equals(fieldTags[i])){ //日期格式
				    		   searchField=Utils.toUpperCaseFirstOne(searchField);
				    		   sb.append("  private  String start").append(searchField).append(";\r\n");
				    		   sb.append("  public   String  getStart").append(searchField).append("() {\r\n ");
								sb.append("	 return start").append(searchField).append(";\r\n");
								sb.append(" }\r\n");
					 			sb.append("  public void setStart").append(searchField).append("(").append("String").append(" start").append(searchField)
					 			  .append(") {\r\n ");
					 			sb.append("  this.start").append(searchField).append("=start").append(searchField).append(";\r\n");
							    sb.append("}\r\n");
							    
							    sb.append("  private  String end").append(searchField).append(";\r\n");
					    		sb.append("  public   String  getEnd").append(searchField).append("() {\r\n ");
							    sb.append("	 return end").append(searchField).append(";\r\n");
							    sb.append(" }\r\n");
						 	    sb.append("  public void setEnd").append(searchField).append("(").append("String").append(" end").append(searchField)
						 			  .append(") {\r\n ");
								    sb.append("  this.end").append(searchField).append("=end").append(searchField).append(";\r\n");
								    sb.append("}\r\n");
				    		   
				      } else {
			       if  (!"".equals(dataType)){
			    	  
			    	sb.append("  private  ").append(dataType).append(" ").append(searchField).append(";\r\n");
			    	
			    	sb.append("  public ").append(dataType).append(" get").append(Utils.toUpperCaseFirstOne(searchField)).append("() {\r\n ");
					sb.append("	 return ").append(searchField).append(";\r\n");
					sb.append(" }\r\n");
		 			sb.append("  public void set").append(Utils.toUpperCaseFirstOne(searchField)).append("(").append(dataType).append(" ").append(searchField)
		 			  .append(") {\r\n ");
				    sb.append("	this.").append(searchField).append("=").append(searchField).append(";\r\n");
				    sb.append("}\r\n");
			    	   }
				    sb.append(" \r\n");
			       }
			      }
			    }
               }
			     sb.append("}");
			     
		 }catch(Exception ex){
			 ex.printStackTrace();
			 return ex.getMessage();
			// ex.printStackTrace();
		 }
			 
			String realPath=paraForm.getUploadPath()+"/"+paraForm.getPackageName().replaceAll("\\.","/");
			 realPath+="/domain/query/"+clsName+".java";
			 return Utils.generateJava(realPath, sb);

	}

}
