package com.huigou.uasp.builder.filer;

//import java.io.File;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.BuildCommon;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.ButtonTypeInter;
import com.huigou.uasp.builder.vo.ButtonAttributeVO;
import com.huigou.uasp.builder.vo.ButtonDefineVO;
import com.huigou.uasp.builder.vo.ParamFormVO;
import com.huigou.uasp.builder.vo.SeleListCustomVO;
import com.huigou.uasp.util.Constant;
import com.huigou.uasp.util.Utils;
import com.huigou.util.ApplicationContextWrapper;
import com.huigou.util.ClassHelper;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author lxh
 * @DATE 2019年08月10日
 * @Description 生成JS页面
 */
@Service("buildPageJSFile")
public class BuildPageJSFile extends BuildCommon implements BuildFilerInter {
		
	  @Override
	public String generateFile(ParamFormVO paraForm,List<Map<String, Object>> fieldList)  throws Exception{

		  String entityName= toHumpOfCamel(paraForm.getTableName());
          //String filePathName=paraForm.getUploadPath()+"/"+paraForm.getFormPath()+"/"+entityName+"List.js";
		  String filePathName="";
		  if (paraForm.getUploadPath()!=null&&!"".equals(paraForm.getUploadPath())){   //linux下缺少/的问题
			  filePathName=paraForm.getUploadPath()+"/"+paraForm.getFormPath()+"/"+entityName+"List.js";
		  } else {
			  filePathName =paraForm.getFormPath()+"/"+entityName+"List.js";
		  }

       	  return Utils.generateFile(filePathName,generateContents(paraForm,Utils.toUpperCaseFirstOne(entityName),null,false,""));
	}

	/* 文件内容生成说明
	 * 参数：paraForm：表单参数对象  mainTableName :主表   mainTableFields 主表字段  isDetail:当前操作是否是生成明细页面的js, queryUrl ：查询数据URL
	 */
    public StringBuffer generateContents(ParamFormVO paraForm,String mainTableName,String []mainTableFields,boolean isDetail,String queryUrl){

		  StringBuffer sb=new StringBuffer("");
          String entityName= toHumpOfCamel(paraForm.getTableName());
          initPage(sb,paraForm,isDetail,entityName);

	 	 if (isDetail&&"grid".equals(paraForm.getDisplayMode())) { //自定义按钮绑定方法
		    composeCustomButtonEvents(paraForm,sb);
		 }
          //组装Grid
         composeGridObject(sb,paraForm,mainTableName,isDetail,queryUrl);
		
		if (isDetail){ //是生成明细页面的js   添加明细页面表单字段效验的处理
		    try {
                Utils.composeDetailCheckFunction(paraForm, mainTableFields, sb);
            }catch(Exception ex){
		        ex.printStackTrace();
            }
			sb.append(Constant.SYSMBOL_LINE);
	    }

		//生成工具栏按钮的执行方法
		 if (paraForm.getButtonDefines().size()>0){
		   	     ButtonAttributeVO btnAttr=new ButtonAttributeVO();
				 
				 btnAttr.setIsForm(paraForm.getIsform());
			 	 btnAttr.setFormName(paraForm.getFormName());
			 	 btnAttr.setParentEntityName(toHumpOfCamel(mainTableName));
			 	 btnAttr.setEntityName(entityName);//toHumpOfCamel(paraForm.getTableName()));

		    for (int i=0;i< paraForm.getButtonDefines().size();i++){
				     btnAttr.setButtonName(paraForm.getButtonDefines().get(i).getButtonName());
				     btnAttr.setButtonMethodName(paraForm.getButtonDefines().get(i).getButtonMethodName());

  				   List<String> detailTablesList = new ArrayList<String>();
				   if (paraForm.getDetails() != null ){
					  paraForm.getDetails().forEach(detail->{
						  detailTablesList.add(toHumpOfCamel(detail.getTableName()));
					  });
				   }
				     btnAttr.setDetailTableName(detailTablesList);

				     ClassHelper.copyProperties(paraForm,btnAttr);

				    getButtonBeanFromContext(paraForm.getButtonDefines().get(i).getButtonMethodName())
				                            .processOutResult(sb, btnAttr);
				}
		 }

         initPageDefaultMethod(sb,entityName);
         return  addNewLineSymbol(sb,false);
	}

     //初始化页面加载方法
	private void initPage(StringBuffer sb,ParamFormVO paraForm,boolean isDetail,String entityName){

        sb.append(" var ").append(entityName).append("GridManager = null, refreshFlag = false;");
        sb.append(" $(document).ready( function () {");
        sb.append("    initUI();");
        if (isDetail&&"grid".equals(paraForm.getDisplayMode())) { //是生成明细页面的js 且是栅格列表  按钮绑定方法
            sb.append("   bind").append(Utils.toUpperCaseFirstOne(entityName)).append("BtnEvents();");
        } else {
            sb.append("   init").append(Utils.toUpperCaseFirstOne(entityName)).append("ListGrid();");
        }
        sb.append("  });");
        sb.append(Constant.SYSMBOL_LINE);

        sb.append("function initUI() {");
        sb.append("    UICtrl.initDefaultLayout();");
        String mainEntityName=""; //主表实体名称
        if (isDetail) { //是生成明细页面的js  增加初始化方法
            sb.append("  if ($('#procId').val() != \"\") { "); //增加判断是否存在流程ID  是则添加初始化新增的方法
            mainEntityName= toHumpOfCamel(paraForm.getMainTableName());
            sb.append("    initAdd").append(Utils.toUpperCaseFirstOne(mainEntityName)).append("(); ");
            sb.append("  } ");
        }
        sb.append(" }");
        sb.append(Constant.SYSMBOL_LINE);
    }

    //组装Grid表格对象
    private void composeGridObject(StringBuffer sb,ParamFormVO paraForm,String mainTableName,boolean isDetail,String queryUrl){
        String entityName= toHumpOfCamel(paraForm.getTableName());
        sb.append("function init").append(Utils.toUpperCaseFirstOne(entityName)).append("ListGrid() { ");
        sb.append("  var toolbarOptions =[];");

        if (paraForm.getButtonDefines()!=null&&paraForm.getButtonDefines().size()>0){ //表格定义了按钮
            composeGridDisplayButton(paraForm,queryUrl,sb);
        }
        sb.append(Constant.SYSMBOL_LINE);

        sb.append("  ").append(entityName).append("GridManager = UICtrl.grid('#")
                .append(entityName).append("Grid', {");
        sb.append(Constant.SYSMBOL_LINE);

        //组装列表中显示的列属性
        composeDisplayColumns(paraForm,queryUrl,isDetail,sb);
        //组装表格的参数
        paraForm.setMainTableName(mainTableName);
        composeGridParameter(paraForm,queryUrl,isDetail,sb);

    }

    // 初始化页面默认方法
    private void initPageDefaultMethod(StringBuffer sb,String entityName){

        //生成getId方法
        sb.append("function getId() {");
        sb.append("	    return $(\"#id\").val() || \"\";");
        sb.append("	}");
        sb.append(Constant.SYSMBOL_LINE);
        //生成setId方法
        sb.append("function setId(value)  { ");
        sb.append(" 	$(\"#id\").val(value);");
        // 为文件上传控件绑定业务id
        // $('#fileList').fileList({bizId: leaveId});
        sb.append("   } ");

        sb.append(Constant.SYSMBOL_LINE);
        sb.append("function query(obj) {");
        sb.append("  var param = $(obj).formToJSON();");
        sb.append("  UICtrl.gridSearch(").append(entityName).append("GridManager, param);");
        sb.append("}");
        sb.append(Constant.SYSMBOL_LINE);

        sb.append(" function reload").append(Utils.toUpperCaseFirstOne(entityName)).append("Grid() {")
                .append("     var params = $(\"#queryMainForm\").formToJSON();")
                .append("     UICtrl.gridSearch(").append(entityName).append("GridManager, params);")
                .append("	}");
        sb.append(Constant.SYSMBOL_LINE);

        //sb.append("//重置表单;").append(Constant.SYSMBOL_LINE);;
        sb.append("function resetForm(obj) {");
        sb.append("  $(obj).formClean();");
        sb.append("}");
        sb.append(Constant.SYSMBOL_LINE);

        //关闭窗口
        sb.append(" function onDialogCloseHandler() { ");
        sb.append("    if (refreshFlag) {");
        sb.append("        reload").append(Utils.toUpperCaseFirstOne(entityName)).append("Grid();");
        sb.append("        refreshFlag = false;");
        sb.append("    } ");
        sb.append("} ");
    }

    private  ButtonTypeInter  getButtonBeanFromContext(String beanName){
		ButtonTypeInter object=null;
		try {
			object=(ButtonTypeInter)ApplicationContextWrapper.getContext().getBean(beanName);
		} catch(NoSuchBeanDefinitionException ex){
			object=(ButtonTypeInter)ApplicationContextWrapper.getContext().getBean("custom");
		}
		return object;
	}

   //组装Grid的参数
   private void composeGridParameter(ParamFormVO paraForm,String queryUrl,boolean isDetail,StringBuffer sb){
        sb.append("       dataAction: 'server',");
        String entityName= toHumpOfCamel(paraForm.getTableName());
      //  String fileName=entityName; //首字母小写
        String  mainTableName= paraForm.getMainTableName();
        if (paraForm.getIsform()==1){  //是表单生成器
            if (isDetail){ //是生成明细页面的js
                queryUrl="'/dataManage/slicedQueryDataRecordDetail.ajax'";
                sb.append(" parms: {formId:$(\"#formId\").val()");
                sb.append(",maiTab:'").append(mainTableName).append("'");
                sb.append(",subTab:'").append(paraForm.getTableName()).append("'");
                sb.append(",id:").append("$(\"#id\").val()");
                sb.append("},");
            }else {  //是生成主表页面的JS
                queryUrl="'/dataManage/slicedQueryFormData.ajax'";
                sb.append(" parms: {formNo:$(\"#formNo\").val()");
                sb.append("},");
            }
        } else {         //是代码生成器
            entityName= toHumpOfCamel(mainTableName);
            queryUrl="'/"+entityName+"/slicedQuery"+entityName+".ajax'";
            if (isDetail){ //如果是生成明细页面的列表  queryUrl需要增加参数
                queryUrl+="&formId='+"+"$(\"#formId\").val()";
                queryUrl+="+'&id='+"+"$(\"#id\").val()";
            }else {
               // entityName= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,mainTableName);
                queryUrl="'/"+entityName+"/slicedQuery"+entityName+".ajax'";
                sb.append(" parms: {formNo:$(\"#formNo\").val()");
            }

        }

        sb.append("       url: web_app.name + ").append(queryUrl).append(",");

        if (paraForm.getButtonDefines().size()>0){ //存在工具栏按钮
            sb.append("       toolbar: toolbarOptions,");
        }
        sb.append("       width: '99.8%',");
        sb.append("       height: '100%',");
        sb.append("       heightDiff: -4,");
        sb.append("       sortName: 'sequence',");
        sb.append("       sortOrder: 'asc',");
        sb.append("       checkbox: true,");
        sb.append("       usePager:true,");

        sb.append("       rownumbers: false,");
        sb.append("       enabledEdit: ").append(Boolean.toString(allowEdit)).append(",");
        sb.append("       fixedCellHeight: true,");
        sb.append("       selectRowButtonOnly:true");

        if (isDetail){  //是明细页面的js  需要进行编辑
            sb.append(" ,onAfterEdit:bind").append(entityName).append("Event");
            sb.append(",autoAddRowByKeydown:true"); //允许自动增加编辑行
            sb.append("     ,onAfterAddRow:function(rows){ var id = getId(); if (id!=''){ saveRow")
                    .append(Utils.toUpperCaseFirstOne(entityName)).append("(\"\"); }  }");
        }

        sb.append("       ,onSuccess:function(data){ ");
        sb.append("         if (data.error){ Public.tip(data.error);} }");

        if (doubleClick){ //数据行允许双击事件
            sb.append("       ,onDblClickRow: function(data, rowindex, rowobj) ");
            sb.append("       { ");
            sb.append("	         doShowUpdateDialog(data.id);");
            sb.append("       }");
        }
        sb.append("    });");
        sb.append("    UICtrl.setSearchAreaToggle(").append(entityName).append("GridManager);");
        sb.append(" 	}");
        sb.append(Constant.SYSMBOL_LINE);
    }

	//组装显示的列  是查询的主页面queryUrl为空
    private void composeDisplayColumns(ParamFormVO paraForm,String queryUrl,boolean isDetail,StringBuffer sb){
		// String fileName=entityName; //首字母小写
		String []fieldEns=paraForm.getFieldEns();
		if (paraForm.getIsform()==0){ //代码生成器
			fieldEns=paraForm.getRealFieldEns();
			String tfstr="";
			for (int u=0;u<fieldEns.length;u++) {
				if (fieldEns[u]!=null) {
					tfstr = toHumpOfCamel(fieldEns[u]); //转驼峰法
					fieldEns[u] = tfstr;
				}
			}
		}

		 String []dataSourceTypes=paraForm.getDataSourceTypes();
		 String []dataSources=paraForm.getDataSources();
		 String []widths=paraForm.getWidths();

		 String []displayField=paraForm.getDisplayFields();
		if (paraForm.getIsform()==0){ //代码生成器
			displayField=paraForm.getRealFieldEns();
		}
		 String []displayFieldname=paraForm.getDisplayFieldnames();
	     String []displayFieldType=paraForm.getDisplayFieldTypes();
	     String []mustInput=paraForm.getMustinputFields();
	     List <SeleListCustomVO> customSqlList=paraForm.getSelectCustoms();

	     String  []maxLengths=paraForm.getFieldsLengths();
	     String  []defaultOperations=paraForm.getDefaultOperation();

		  sb.append("      columns: [");
		  double percents=0.00;
		  if  (displayField.length>0){
		    percents=98/displayField.length;  //每列占宽度百分比
		  }
		  List <String> hideCols=new ArrayList<String>();
		  hideCols.add("id");

		   String dataSourceType="",dataSource="",tagType="input";
			  //entityName= mdmDataMaterialaSupply
		   //String queryParams="?tableName="+paraForm.getTableName();
	    for (int i=0;i<displayField.length;i++){
	       	if (i>displayField.length-2){
	    		percents=percents-1;
	    	}
	       	int w=0;
	   	   for (int j=0;j<fieldEns.length;j++) {
			 if (displayField[i].equals(fieldEns[j])){
				// chName=fieldchs[j];
				  tagType=paraForm.getFieldTags()[j];
				 if (dataSourceTypes.length>j){
				    dataSourceType=dataSourceTypes[j];
				 }
				 if (dataSources.length>j){
				    dataSource=dataSources[j];
				 }
				 break;
			 }
	   	   }
			if (paraForm.getIsform()==1) {  //是表单生成器
				w = Integer.parseInt(displayField[i].substring(5));  //由于主表存在文件、分割线等非字段组件
			} else {
				w=i;
			}
	   	   	sb.append("     {display:\""+displayFieldname[i]+"\",name:\"");

			 if (paraForm.getIsform()==1){  //是表单生成器
				 sb.append(displayField[i]).append("\"");

			 } else {  //直接生成代码的
			   if ("select".equals(tagType)){  //数据来源为数据字典的下拉框

				 if (allowEdit){
				    sb.append(displayField[i]).append("\"");
		    	  } else { //不能编辑的
					    if (dataSource!=null&&!"".equals(dataSource)){
						     sb.append(dataSource);
						 }else {
							 sb.append(displayField[i]);
						 }
						 sb.append("TextView\"");

				  }
		       } else {
		    	 sb.append(displayField[i]).append("\"");
		       }
			 }
			//if (isDetail) {
				sb.append(",width:"+widths[w]+",minWidth:\"60\"");
			//} else {
			//	sb.append(",width:\""+percents+"%\",minWidth:\"60\"");
			//}


	       	if ("date".equalsIgnoreCase(displayFieldType[i])){
	       		sb.append(",align:\"left\",type:\"date\"");
	       	 	if (allowEdit){
	       	 	  sb.append(",editor:{type:'date',mask:'date',");
	       	 	  if ("1".equals(mustInput[i])){
	       	 	     sb.append("required:true");
	       	 	  } else {
	       	 		 sb.append("required:false");
	       	 	  }
	       	 	  sb.append("}");
	       	 	}
	       	} else if (displayFieldType[i].startsWith("number")){
	       		if ("select".equals(tagType)){
	       			sb.append(",align:\"right\",type:\"string\"");
	       		} else {
	       		    sb.append(",align:\"right\",type:\"money\"");
	       		}
	       		if (allowEdit){
					//sb.append(",editor:{type:'text',mask : '999999999.99',");
					if  (displayFieldType[i].equalsIgnoreCase("number")){
						sb.append(",editor:{type:'text',mask : 'number',");
					} else {  //带有小数点的
						String decimal=displayFieldType[i].replace("number","");
						String decimalStr="";
						for (int k=0;k<Integer.parseInt(decimal);k++){
							decimalStr+="9";
						}
						sb.append(",editor:{type:'text',mask : '999999999.").append(decimalStr)
					    .append("',");
					}
	       	 	  if ("1".equals(mustInput[i])){
		       	 	     sb.append("required:true");
		       	   } else {
		       	 		 sb.append("required:false");
		       	   }
		       	  sb.append("}");
	       		}
	    	} else {
	    		 sb.append(",align:\"left\",type:\"string\"");
	    		if (allowEdit){
	    			 if (Constant.SELECT_TAG.equals(tagType)){  //数据来源为数据字典的下拉框
	    				// allowNewLine=false; //此处不允许换行了   因为js引号转义

	    			    sb.append(",editor: {");
	    			    if ("1".equals(mustInput[i])){
				       	   sb.append("required:true,");
				       	 } else {
				       	   sb.append("required:false,");
				       	 }
	    			  if (Constant.DATASOURCETYPE_DICT.equals(dataSourceType)){
	    				  hideCols.add(displayField[i]+"_dictcode");
	  		            sb.append(" type: \"dynamic\",")
	  		             .append("    getEditor: function (row) {")
   		                 .append("    var _fieldCode = \"return {type:'select',data:{ type:'saf',name:'selectDictValueByCode',getParam:function(){ return { code:'").append(dataSource).append("' } ; },\";")
			             .append("  _fieldCode+=\"back:{name:\\\"").append(displayField[i]).append("\\\",value:\\\"").append(displayField[i]).append("_dictcode\\\" } } } \";")

	  		             .append("        _fieldCode = (new Function(_fieldCode))();")
	  		             .append("         return _fieldCode;");
	  		           sb.append("      }");
	  				   sb.append(" } ");
	    			  } else  if (Constant.DATASOURCETYPE_SQL.equals(dataSourceType)){  //自定义ＳＱＬ　
	    				  //需要找到检索SQL的参数条件、返回值 字段
	    				 // String []condiCols=null;
	    				  String []backFields=null;
	    				  String []fieldTypes=null;
	    				  String []fieldCodes=null;
	    				  String []paramFields=null,paramSourceFields=null,allFieldEns=null;
	    				  for (SeleListCustomVO customSqlVO:customSqlList){
	    					  if (dataSource.equals(customSqlVO.getSearchName())){
	    						 hideCols.addAll(Utils.getHiddenFields(customSqlVO));
	    						 fieldTypes=customSqlVO.getFieldTypes().split(",");
	    						 backFields=customSqlVO.getBackFields().split(",");
	    						 fieldCodes=customSqlVO.getFieldCodes().split(",");
	    						 allFieldEns=customSqlVO.getFieldEns();
	    						 paramFields=customSqlVO.getParamFields()!=null?customSqlVO.getParamFields().split(","):new String[0];
	    						 paramSourceFields=customSqlVO.getParamSourceFields()!=null?customSqlVO.getParamSourceFields().split(","):new String[0];
	    						// condiCols=customSqlVO.getCondiColumns()!=null?customSqlVO.getCondiColumns().split(","):new String[0];
	    						 break;
	    					  }
	    				  }
	    				  sb.append(" type: \"dynamic\",")
		  		             .append("    getEditor: function (row) {")
	   		                 .append("    var _fieldCode = \"return {type:'select',data:{ type:'saf',name:'")
	   		                 .append(dataSource).append("',frmType:'").append(paraForm.getFormPath()).append("',getParam:function(){ return { ");
	   		                 //.append(" code:'").append(dataSource).append("'")
	    				     for ( int t=0;t<paramFields.length;t++){
	    				    	// getDisplayField(fieldEns,displayField,paramSourceFields[t])//根据真实字段获取转换后的显示字段
	    				    	 //if (paraForm.getIsform()==1){  //是表单生成器   如果是生成代码 ？？？
	    				    	sb.append(paramFields[t]).append(":'\"+row.").append( getDisplayField(allFieldEns,displayField,paramSourceFields[t])).append("+\"'");
	    				    	if (t<paramFields.length-1){
	    				    		sb.append(",");
	    				    	}
	    				     }
	   		                 sb.append(" } ; },\";")
				             //.append("  _fieldCode+=\"back:{name:\\\"").append(displayField[i]).append("\\\",value:\\\"").append(displayField[i]).append("_dictcode\\\" } } } \";")
	   		                 .append("  _fieldCode+=\"back:{");
		    			    for ( int r=0;r<backFields.length;r++){
		    			    	if ("1".equals(fieldTypes[r])){  //隐藏字段
		    			    		sb.append(fieldCodes[r]).append(":\\\"").append(backFields[r]).append("\\\"");
		    			    		//sb.append("name:\\\"").append(backFields[r]).append("\\\",value:\\\"").append(backFields[r]).append("\\\"");
		    			    	} else {  //如果是多个返回字段 displayField[i] -->displayField[r] 07.03
		    			    		sb.append(fieldCodes[r]).append(":\\\"").append(getDisplayField(allFieldEns,displayField,backFields[r])).append("\\\"");
		    			    	   // sb.append("name:\\\"").append(backFields[r]).append("\\\",value:\\\"").append(displayField[i]).append("\\\"");
		    			    	}
		    			    	if (r<backFields.length-1){
	    				    	   sb.append(",");
	    				    	}
		    			    }
	   		                 sb.append(" } } } \";");
		  		             sb.append("        _fieldCode = (new Function(_fieldCode))();")
		  		             .append("         return _fieldCode;");
		  		           sb.append("      }");
		  				   sb.append(" } ");
	    			  }

	    			 } else {  //普通输入框
						 if  (!"".equals(queryUrl)){
							 if (Constant.READ_WRITE.equals(defaultOperations[i])) { //允许编辑的
								 sb.append(",editor:{type: 'text',maxLength:'").append(maxLengths[i]).append("',");
								 if ("1".equals(mustInput[i])) {
									 sb.append("required:true");
								 } else {
									 sb.append("required:false");
								 }
								 sb.append("}");
							 } else {  //不允许编辑  改变显示的颜色
								 sb.append(",render:function(row) { var html =\"<span style='color:blue'>\"+row.").append(displayField[i])
										 .append("+\"</span>\"; return html;}");
							 }
						 }
	    			 }
	    	    }
	    	}
	    	sb.append("},");
			sb.append(Constant.SYSMBOL_LINE);
	   }
        if (!isDetail) { // 是主页面 ，非明细页面 必定有状态字段
            sb.append("     {display: '状态', name: 'status', width: 50, minWidth: 40, align:\"left\",")
                    .append("render: function (item) { ")
                    .append("  if ($('#procId').val()!=\"\") { ");
            if (allowEdit) {
                sb.append("	return UICtrl.getStatusInfo(item.status); ");
            } else {
                sb.append("  return UICtrl.getApproveStatusInfo(item.status); ");
            }
            sb.append("  } else { ")
                    .append("    return UICtrl.getStatusInfo(item.status);} } }");
			if (hideCols.size()>0) {
				sb.append(",");
			}
			for (int u=0;u<hideCols.size();u++) {
				sb.append("   {display:\"\", name:\"").append(hideCols.get(u)).append("\",hide:true}");
				if (u<hideCols.size()-1){
					sb.append(",");
				}
			}
        } else {  //明细页面 存在Tab页签 去掉隐藏字段列
			if (paraForm.getTabLabels().size()>0){  //存在Tab页签的情况 不加隐藏列
			//	String sbstr=sb.toString().trim();
			//	if  (sbstr.endsWith("}},")){
			//		sb=new StringBuffer(sbstr.substring(0,sbstr.length()-1));
			//	}
			} else {
				if (hideCols.size()>0) {
					for (int u=0;u<hideCols.size();u++) {
						sb.append("   {display:\"\", name:\"").append(hideCols.get(u)).append("\",hide:true}");
						if (u<hideCols.size()-1){
							sb.append(",");
						}
					}
				}
			}
		}


		sb.append("],");
		sb.append(Constant.SYSMBOL_LINE);
	}



	//组装显示的按钮
    private void composeGridDisplayButton(ParamFormVO paraForm,String queryUrl,StringBuffer sb){
		if (paraForm.getButtonDefines().size()>0){
			String entityName= toHumpOfCamel(paraForm.getTableName());
			  // String fileName=entityName; //首字母小写
		    sb.append("  toolbarOptions = UICtrl.getDefaultToolbarOptions({");
		     String mainEntityName="";
		   if (paraForm.getMainTableName()!=null){
		     mainEntityName=toHumpOfCamel(paraForm.getMainTableName());
		   }
		   for (int i=0;i<paraForm.getButtonDefines().size();i++){
			 if (paraForm.getButtonDefines().get(i).getButtonMethodName().indexOf("_custom")>0){ //自定义按钮
			  sb.append("    ").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler:{  id: '")
					  .append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append(i)
			    .append("',text: '").append(paraForm.getButtonDefines().get(i).getButtonName())
			    .append("',img: 'fa-user', click: ").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler}");
			 } else { //系统默认按钮类型
				   //添加行按钮 （明细页面的）
				 if ("addRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ){
					 allowEdit=true;
					 doubleClick=false;

					 sb.append("addRowHandler:{")
					 .append("id:'insertRowHandler',")
					 .append("img:'fa-plus',")
				     .append("text:'添加行',")
					 .append("click:function(){ ")
					 .append("doSave").append(Utils.toUpperCaseFirstOne(mainEntityName)).append("ByDetail(\"")
					 .append(entityName).append("GridManager\");")

					 .append("}")
					 .append("}");

				 } else  if ("deleteRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ){

						 sb.append("    deleteRowHandler:{")
						 .append("id:'deleteRowHandler',")
						 .append("img:'fa-trash',")
					     .append("text:'删除行',")
						 .append("click:function(){")
						 .append("").append(paraForm.getButtonDefines().get(i).getButtonMethodName())
								 .append(Utils.toUpperCaseFirstOne(entityName)).append("();")
						 .append("}")
						 .append("}");
				 } else  if ("saveRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ){
					 sb.append("     saveRowHandler:{")
					 .append("id:'saveRowHandler',")
					 .append("img:'fa-save',")
				     .append("text:'保存行',")
					 .append("click:function(){")
					 .append("").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append(Utils.toUpperCaseFirstOne(entityName)).append("(\"\");")
					 .append("}")
					 .append("}");
				 } else  if ("enableRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ){
					 sb.append("     enableRowHandler:{")
					 .append("id:'enableRowHandler',")
					 .append("img:'fa-thumbs-o-up',")
				     .append("text:'启用行',")
					 .append("click:function(){")
					 .append("").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append(Utils.toUpperCaseFirstOne(entityName)).append("();")
					 .append("}")
					 .append("}");
				 } else  if ("disableRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ) {
					 sb.append("     disableRowHandler:{")
							 .append("id:'disableRowHandler',")
							 .append("img:'fa-thumbs-down',")
							 .append("text:'禁用行',")
							 .append("click:function(){")
							 .append("").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append(Utils.toUpperCaseFirstOne(entityName)).append("();")
							 .append("}")
							 .append("}");
					 // } else  if ("saveRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName()) ){
					 //在下面根据是否存在流程 添加
				  } else if (paraForm.getButtonDefines().get(i).getTableName()!=null&&!"".equals(paraForm.getButtonDefines().get(i).getTableName())) {   //明细表自定义按钮
					   sb.append("    ").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler:{  id: '")
							 .append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append(i)
							 .append("',text: '").append(paraForm.getButtonDefines().get(i).getButtonName())
							 .append("',img: 'fa-user', click: ").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler}");
				 } else {   //主表 默认的按钮类型
		            sb.append("").append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler:")
		             .append(paraForm.getButtonDefines().get(i).getButtonMethodName()).append("Handler");
				 }
			 }

		     if (i<paraForm.getButtonDefines().size()-1){
		        sb.append(",");
		     }
		      sb.append("");
		   } //ended for
		     sb.append("   });");
			   //如果是明细表 需要增加
			/*for (int i=0;i<paraForm.getButtonDefines().size();i++) {
				if ("saveRow".equals(paraForm.getButtonDefines().get(i).getButtonMethodName())) {

					sb.append("  if ($('#procId').val()==\"\") {");  //增加是否配置流程
					sb.append("  toolbarOptions.items[toolbarOptions.items.length] =  {id:'saveRowHandler',img:'fa-save',text:'保存行',click:function(){ ")
							.append("saveRow").append(Utils.toUpperCaseFirstOne(entityName)).append("(\"\");}};");
					sb.append(" }");
				}
			} */

			}
	
	}

	//组装自定义的按钮  未实现完  待完善？？？
    private void composeCustomButtonEvents(ParamFormVO paraForm,StringBuffer sb){
		if (paraForm.getButtonDefines().size() > 0) {
			String entityName= toHumpOfCamel(paraForm.getTableName());
			sb.append(" function  bind").append(Utils.toUpperCaseFirstOne(entityName)).append("BtnEvents(){ ");

				for (ButtonDefineVO btnVO : paraForm.getButtonDefines()) {
					sb.append("$(\"#").append(btnVO.getButtonMethodName()).append("\").click(function(){ ");

					if (!"".equals(btnVO.getProcedureName())){

					} else 	if (!"".equals(btnVO.getButtonMethodContent())){
						sb.append(btnVO.getButtonMethodContent());
					} else {
						sb.append(" alert(''); ");
						/*sb.append(" $('#").append(entityName).append("Form').ajaxSubmit({");
						sb.append("  url: web_app.name + \"/dataSupply/saveDataSupply.ajax\",");
								sb.append("	 param:{id:getId(),gridData:encodeURI($.toJSON(datas))},");
						sb.append(" success: function (data) {");
								sb.append("	");
								sb.append("	}");
						sb.append("});"); */
					}
				    sb.append(" });");
				}
			sb.append(" } ");
			sb.append(Constant.SYSMBOL_LINE);
		}

	}

	//获取真实字段的显示字段名称  field0、field1、field2....
	// 明细表的 fieldEns//已经是field0...??? 
    private String  getDisplayField(String []fieldEns,String []displayFields,String fieldName){
	  String displayField=fieldName;
	  for (int j=0;j<fieldEns.length;j++) {
			 if (fieldName.equals(fieldEns[j])){
				 displayField=displayFields[j];
				 break;
			 }
	   	   }
	  return displayField;
	  
    }

}
