package com.huigou.uasp.builder.filer;

import java.io.File;
import java.util.*;
import java.util.stream.Stream;

import com.huigou.uasp.builder.BuildCommon;
import com.huigou.uasp.builder.pagetag.*;
import com.huigou.uasp.builder.vo.*;
import com.huigou.uasp.form.domain.model.FormAttachVO;
import com.huigou.uasp.form.domain.model.FormParameter;
import com.huigou.uasp.util.ComUtils;
import com.huigou.util.ClassHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.BuildTypeClass;
import com.huigou.uasp.builder.FieldTagTypeInter;
import com.huigou.uasp.util.Utils;
import com.huigou.uasp.util.Constant;

/**
 * @author lxh
 * @DATE 2019年08月10日
 * @Description 生成明细页面 
 */

@Service("buildPageDetailFile")
public class BuildPageDetailFile extends BuildCommon implements BuildFilerInter {

	@Autowired
	private BuildPageJSFile buildPageJSFile;


	@Override
	public String generateFile(ParamFormVO paraForm, List<Map<String, Object>> fieldList) throws Exception {

		String entityName = toHumpOfCamel(paraForm.getTableName());
		//StringBuffer sb = generateContents(paraForm, entityName);
		//String filePathName = paraForm.getUploadPath() + "/" + paraForm.getFormPath() + "/" + entityName + "Detail.jsp";
		String filePathName="";
		if (paraForm.getUploadPath()!=null&&!"".equals(paraForm.getUploadPath())){   //linux下缺少/的问题
			filePathName=paraForm.getUploadPath() + "/" + paraForm.getFormPath() + "/" + entityName + "Detail.jsp";
		} else {
			filePathName = paraForm.getFormPath() + "/" + entityName + "Detail.jsp";
		}
		return Utils.generateFile(filePathName, generateContents(paraForm, entityName));

	}

	public String generateFile(String filePathName, StringBuffer sb) throws Exception {
		return Utils.generateFile(filePathName, sb);
	}

	//如果是不存在明细表的 则parentEntityName即entityName
	public StringBuffer generateContents(ParamFormVO paraForm, String mainTableName) {

		StringBuffer sb = new StringBuffer("");
		sb.append("<%@ page contentType=\"text/html; charset=utf-8\" language=\"java\"%>").append(Constant.SYSMBOL_LINE);
		sb.append("<%@ taglib uri=\"/WEB-INF/taglib.tld\" prefix=\"x\"%>").append(Constant.SYSMBOL_LINE);
		sb.append("<%@ taglib uri=\"http://java.sun.com/jsp/jstl/core\" prefix=\"c\"%>").append(Constant.SYSMBOL_LINE);

		//存在明细表单页面
		if (paraForm.getDetails().size() > 0) {
			EasySearchVO easySearchVO = new EasySearchVO();
			ClassHelper.copyProperties(paraForm, easySearchVO);
			paraForm.setEasySearchVO(easySearchVO);
			generateDetailFile(paraForm, mainTableName, sb);
		}
		List <String>dList=countPieces(paraForm);

		int startSeq=0,endSeq=0; boolean hasFormHead=false; //有form头信息
		if ("m".equals(dList.get(0).split(":")[2])) {  //是以主表开始的
			getFormHead(paraForm, sb);
			hasFormHead = true;
		}
		boolean noEndMainForm=false; //是否存在Form结束标记
		for(int u=0;u<dList.size();u++){
			   noEndMainForm=false;
			if ("m".equals(dList.get(u).split(":")[2])) {
				if (!hasFormHead) {
					getFormHead(paraForm, sb);
				}
				endSeq=Integer.parseInt(dList.get(u).split(":")[0]);
				sb.append(" <div class=\"hg-form-cols\"> ").append(Constant.SYSMBOL_LINE);
				//生成表单标签元素
				generateFieldTag(paraForm,sb,startSeq,endSeq);

				sb.append(" </div>").append(Constant.SYSMBOL_LINE);
				for(int k=u+1;k<dList.size();k++) {
					if ("m".equals(dList.get(k).split(":")[2])) {
						noEndMainForm=true;
						break;
					}
				}
				if (!noEndMainForm) {
					sb.append("</form>").append(Constant.SYSMBOL_LINE);
				}
			} else {
				   for (int j = 0; j < paraForm.getDetails().size(); j++) {
					   if (dList.get(u).split(":")[1].equals(paraForm.getDetails().get(j).getTableName())) {
						   if (paraForm.getDetails().get(j).getTabLabels().size() == 0) { //无标签页的
							   sb.append("<div class=\"clearfix\"></div>").append(Constant.SYSMBOL_LINE);
							   sb.append("<div class=\"dividing-div\"><font class=\"dividing-font\">&nbsp;&nbsp;")
   							     .append(paraForm.getDetails().get(j).getFormName()).append("列表  </font><br></div>").append(Constant.SYSMBOL_LINE);
							   sb.append(" <div id=\"").append(toHumpOfCamel(paraForm.getDetails().get(j).getTableName()))
							     .append("Grid\" style=\"margin: 2px;\"></div>").append(Constant.SYSMBOL_LINE);
							   break;
						   }
					   }
				   }
			}

			startSeq=Integer.parseInt(dList.get(u).split(":")[0]);
		 }
		  getTabsLayout(sb,paraForm.getDetails(),paraForm);  //单独处理页签输出

       return sb;
	}

    //计算页面布局区域
	private List<String> countPieces(ParamFormVO paraForm){
		int lens=paraForm.getSequences().length+paraForm.getDetails().size();
		String []allseqs=new String[lens];
		for(int i=0;i<paraForm.getSequences().length;i++){
			allseqs[i]=paraForm.getSequences()[i]+":"+paraForm.getTableName()+":m";
		}
		for (int j = 0; j < paraForm.getDetails().size(); j++) {
			String []seqdetails = paraForm.getDetails().get(j).getSequences();
			allseqs[paraForm.getSequences().length+j] = seqdetails[seqdetails.length-1]+":"+paraForm.getDetails().get(j).getTableName()+":s";
		}

		for(int i=0;i<allseqs.length;i++){  //重新排序
			for(int j=i+1;j<allseqs.length;j++){
				if(Integer.parseInt(allseqs[i].split(":")[0])>Integer.parseInt(allseqs[j].split(":")[0])){
					String temp=allseqs[i];
					allseqs[i]=allseqs[j];
					allseqs[j]=temp;
				}
			}
		}
		List <String>list=new ArrayList();
		for(int i=0;i<allseqs.length;i++){
			if ("s".equals(allseqs[i].split(":")[2])) { //子表
				if (!list.contains(allseqs[i].split(":")[0]+":"+allseqs[i].split(":")[1]+":s")) {
					list.add(allseqs[i].split(":")[0] + ":" + allseqs[i].split(":")[1]+":s");
				}
			} else { //主表
				for(int j=i+1;j<allseqs.length;j++){
					if ("s".equals(allseqs[j].split(":")[2])) {
						list.add(allseqs[j-1].split(":")[0]+":"+allseqs[j-1].split(":")[1]+":m");
						i=j-1;
						list.add(allseqs[j].split(":")[0]+":"+allseqs[j].split(":")[1]+":s");
					} else if (j==allseqs.length-1){
						if (!list.contains(allseqs[j].split(":")[0]+":"+allseqs[j].split(":")[1]+":m")) {
							list.add(allseqs[j].split(":")[0] + ":" + allseqs[j].split(":")[1]+":m");
						}
					}
				}
			}
		}
		return list;
	}

	private  void getFormHead(ParamFormVO paraForm,StringBuffer sb){
		sb.append("<form class=\"hg-form\" method=\"post\" action=\"\" id=\"submitForm\">").append(Constant.SYSMBOL_LINE);
		//} else{
		//   sb.append("<form class=\"hg-form\" method=\"post\" action=\"\" id=\"").append(entityName).append("Form\">").append(Constant.SYSMBOL_LINE);
		// }
		for (String hiddenField : paraForm.getHiddenFields()) {
			sb.append("   <x:hidden name=\"").append(hiddenField).append("\" />").append(Constant.SYSMBOL_LINE);
		}
		sb.append("   <x:hidden name=\"procId\" />").append(Constant.SYSMBOL_LINE);

		//存在流程的 添加固定的隐藏字段
		if (!"".equals(paraForm.getProcId())){
			List<String> realFieldList = Arrays.asList(paraForm.getRealFieldEns());
			sb.append("<c:if test=\"${procId!=''}\">").append(Constant.SYSMBOL_LINE);
			sb.append("   <x:hidden name=\"taskId\" />").append(Constant.SYSMBOL_LINE);
			if (!realFieldList.contains("bill_code")) {
				sb.append("   <x:hidden name=\"billCode\"/>").append(Constant.SYSMBOL_LINE);
			}
			if (!realFieldList.contains("fillin_date")) {
				sb.append("   <x:hidden name=\"fillinDate\" type=\"datetime\"/>").append(Constant.SYSMBOL_LINE);
			}
			sb.append("   <x:hidden name=\"fullId\"/>").append(Constant.SYSMBOL_LINE);
			sb.append("   <x:hidden name=\"organId\"/>").append(Constant.SYSMBOL_LINE);
			if (!realFieldList.contains("organ_name")) {
				sb.append("   <x:hidden name=\"organName\"/>").append(Constant.SYSMBOL_LINE);
			}
			sb.append("   <x:hidden name=\"deptId\"/>").append(Constant.SYSMBOL_LINE);
			if (!realFieldList.contains("dept_name")) {
				sb.append("   <x:hidden name=\"deptName\"/>").append(Constant.SYSMBOL_LINE);
			}
			sb.append("   <x:hidden name=\"positionId\"/>").append(Constant.SYSMBOL_LINE);
			if (!realFieldList.contains("position_name")) {
				sb.append("   <x:hidden name=\"positionName\"/>").append(Constant.SYSMBOL_LINE);
			}
			sb.append("   <x:hidden name=\"personMemberId\"/>").append(Constant.SYSMBOL_LINE);
			sb.append("   <x:hidden name=\"personMemberName\"/>").append(Constant.SYSMBOL_LINE);
		//	sb.append("  <div class=\"dividing-div\"><font class=\"dividing-font\">&nbsp;基本信息</font></div>").append(Constant.SYSMBOL_LINE);

		/*	sb.append(" <div><div class=\"hg-form-cols\"><div class=\"hg-form-row\">").append(Constant.SYSMBOL_LINE);
			sb.append("<x:inputC name=\"billCode\"  label=\"单据编号\"  labelCol=\"2\" fieldCol=\"2\"  readonly=\"true\" maxLength=\"100\" />").append(Constant.SYSMBOL_LINE);
			sb.append("<x:inputC name=\"createdDate\"  label=\"制单日期\"  labelCol=\"2\" fieldCol=\"2\" readonly=\"true\" />").append(Constant.SYSMBOL_LINE);
			sb.append("<x:inputC name=\"createdByName\"  label=\"创建人\"  labelCol=\"2\" fieldCol=\"2\" readonly=\"true\" maxLength=\"20\"/>").append(Constant.SYSMBOL_LINE);
			sb.append("</div></div></div>").append(Constant.SYSMBOL_LINE);*/
			sb.append("</c:if>").append(Constant.SYSMBOL_LINE);
		}
		//sb.append("  <div class=\"dividing-div\"><font class=\"dividing-font\">&nbsp;表单信息</font></div>").append(Constant.SYSMBOL_LINE);
	}


	//生成主表单的标签元素
	private void generateFieldTag(ParamFormVO paraForm, StringBuffer sb,int startSeq,int endSeq) {

		//ParamFormVO paraDetail = null;

		String[] sequences = paraForm.getSequences();
		String[] fieldEns = paraForm.getFieldEns();
		String[] fieldTags = paraForm.getFieldTags();
		if (paraForm.getIsform() == 0) {  //是代码生成器 获取真实字段名称
			fieldEns = paraForm.getRealFieldEns();
			for (int u = 0; u < fieldEns.length; u++) {
				if (!Constant.FILE_TAG.equals(fieldTags[u])&&!Constant.DIVIDER_TAG.equals(fieldTags[u])) {
					fieldEns[u] = toHumpOfCamel(fieldEns[u]); //转驼峰法
				}
			}
		}
		String[] fieldChs = paraForm.getFieldChs();

		String[] mustInputField = paraForm.getMustinputFields();
		String[] fieldsLengths = paraForm.getFieldsLengths();
		String[] defaultOperations = paraForm.getDefaultOperation();

		String[] validatorTypes = paraForm.getValidatorTypes();
		String[] codeRuleIds = paraForm.getCodeRuleId();

         String []labelCols=paraForm.getLabelCols();
         String []fieldCols=paraForm.getFieldCols();
         String []textAreaRows=paraForm.getTextAreaRows();

		String fieldEn = "";
		int rows = countRows(paraForm);
		int cols = Constant.PAGEDETAIL_COLS;//每行显示标签个数
		int x = 0;

		Queue<String> queue = new ArrayDeque<String>();
		for (int y = 0; y < fieldEns.length; y++) {
				if (Integer.parseInt(sequences[y]) > startSeq&&Integer.parseInt(sequences[y]) <= endSeq) {
					queue.add(fieldEns[y]!=null?fieldEns[y]:"");
				}
		}
		List<String> list = new ArrayList<String>();
		FieldTagTypeInter outResults = null;
		FieldAttributeVO fieldAttributes = null;
		int allCols=0;
		for (int i = 0; i < rows; i++) {
			if (queue.isEmpty())
				break;
			sb.append("  <div class=\"hg-form-row\">").append(Constant.SYSMBOL_LINE);
			allCols=0;
			for (int r = 0; r < cols; r++) {
				if (queue.isEmpty())
					break;
				fieldEn = queue.poll();
				for (int y = 0; y < fieldEns.length; y++) {
					if ((fieldEn).equals(fieldEns[y])) {
						x = y;
						break;
					}
				}

				outResults = getFieldTagType(fieldTags[x]);
				fieldAttributes = new FieldAttributeVO();
				fieldAttributes.setFieldEn(fieldEns[x]);
				fieldAttributes.setFieldCh(fieldChs[x]);
				if (codeRuleIds != null) {
					fieldAttributes.setCodeRuleId(codeRuleIds[x]);
				}

				fieldAttributes.setFieldLength(Integer.parseInt(!"".equals(fieldsLengths[x]) ? fieldsLengths[x] : "0"));
				fieldAttributes.setDefaultOperation(defaultOperations[x]);

				fieldAttributes.setLabelCols(Integer.parseInt(labelCols[x]));
				fieldAttributes.setFieldCols(Integer.parseInt(fieldCols[x]));
				fieldAttributes.setMustinputField("1".equals(mustInputField[x]) ? "true" : "false");
				fieldAttributes.setTextAreaRows(Integer.parseInt(textAreaRows[x]));
				//fieldAttributes.setCols(cols);
				//fieldAttributes.setCurrCols(r);
				if (validatorTypes.length > x) {
					fieldAttributes.setValidatorType(validatorTypes[x]);
				}
				if (paraForm.getDataSourceTypes().length > x) {
					fieldAttributes.setDataSourceType(paraForm.getDataSourceTypes()[x]);
				}
				if (paraForm.getDataSources().length > x) {
					fieldAttributes.setDataSource(paraForm.getDataSources()[x]);
				}
				if (paraForm.getCssStyle().length > x) {
					fieldAttributes.setCssStyle(paraForm.getCssStyle()[x]);
				}
				if (paraForm.getCheckFunction().length > x) {
					fieldAttributes.setCheckFunction(paraForm.getCheckFunction()[x]);
				}

				if (Constant.FILE_TAG.equals(fieldTags[x])) {  //文件附件的处理
					fieldAttributes.setDataSource(paraForm.getTableName() + "_" + fieldAttributes.getFieldEn() + ";" + fieldAttributes.getFieldCh());
				}
				list = outResults.processOutResult(sb, fieldAttributes);

				allCols+=Integer.parseInt(labelCols[x])+Integer.parseInt(fieldCols[x]);

				 if (allCols==Constant.TAG_MAXCOLS) {
				 	r=cols; //需要换行
				 }
				/*r = Integer.parseInt(list.get(1));

				if (x < fieldEns.length - 1) {
					if (Constant.TEXTAREA_TAG.equals(fieldTags[x + 1]) ||
							Constant.FILE_TAG.equals(fieldTags[x + 1])
					) {
						r = cols;
					}
				}*/
			}
			sb.append("  </div>").append(Constant.SYSMBOL_LINE);

		}
	}


	//生成明细列表的JSP文件
	private void generateDetailFile(ParamFormVO paraForm, String mainTableName, StringBuffer sb) {
		// String tableName= paraForm.getTableName();
		// String entityMainTable=CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,tableName);//主表
		sb.append(" <head> ").append(Constant.SYSMBOL_LINE);
		List<ParamFormVO> listDetails = paraForm.getDetails();
		ParamFormVO paraDetail = null;
		sb.append("<c:if test=\"${procId!=''}\">").append(Constant.SYSMBOL_LINE);
		sb.append(" <x:base include=\"layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog\" />");
		// sb.append(" <script src='<c:url value=\"/lib/jquery/jquery.datepicker.js\"/>' type=\"text/javascript\"></script>");
		sb.append("</c:if>");
		sb.append(Constant.SYSMBOL_LINE);
		//存在页签的情况
		if (paraForm.getTabLabels()!=null&&paraForm.getTabLabels().size()>0) {
	 	  sb.append("<link href = '<c:url value=\"/themes/css/tabpanel.css\"/>' rel = 'stylesheet' type = 'text/css'/>").append(Constant.SYSMBOL_LINE);
		}
		sb.append(" <script type=\"text/javascript\">").append(Constant.SYSMBOL_LINE);

		  //存在页签的情况
		if (paraForm.getTabLabels()!=null&&paraForm.getTabLabels().size()>0) {
			sb.append("$(function(){ $('.tabPanel ul li').click(function(){ ");
			sb.append("		$(this).addClass('hit').siblings().removeClass('hit');");
			sb.append("		$('.panes>div:eq('+$(this).index()+')').show().siblings().hide(); }) });");
			sb.append(Constant.SYSMBOL_LINE);
		}
		//组装字段效验事件
		sb.append("    $(document).ready( function () {  bindEvent();  });  ").append(Constant.SYSMBOL_LINE);
		Utils.composeMainFormCheckFunction(paraForm, sb);

		//明细表的列表  进行效验 ？？
			/*  onAfterEdit:totalArea,
			  function totalArea(data){
					data=data.record;
					var houseArea=data.field3||0;
					var houseNumber=data.field4||0;
					 var c = data.column;  alert(c);
				            if (c.name == 'field2') {//启用的数据value 不能编辑
				               alert(c.name);
							}
					alert(houseArea);
						smsOrderDetailGridManager.updateCell('ff', houseNumber, data);

				 }
			  */

		if (!"".equals(paraForm.getProcId())){
			getFlowDetailDataMethod(sb, listDetails);
			getFlowAfterSaveMethod(sb, listDetails, paraForm);
			getFlowBeforeSaveMethod(sb, listDetails, paraForm);
		}
			getSaveMainEntityMethod(sb, listDetails, paraForm);
			getInitAddMainMethod(sb, listDetails, paraForm);

		sb.append(" </script> ").append(Constant.SYSMBOL_LINE);
		String formNo = paraForm.getFormPath();
		if (paraForm.getIsform() == 1) {  //表单生成
			formNo = formNo.substring(formNo.indexOf("customform") + 11);
		}
		String queryUrl = "";



		for (int j = 0; j < listDetails.size(); j++) {
			paraDetail = listDetails.get(j);
			String entitySubTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paraDetail.getTableName());
			sb.append(" <script src='<c:url value=\"");
			if (paraForm.getIsform() == 1) {  //表单生成页面
				sb.append(paraForm.getSrcPath());
			}
			sb.append("/").append(formNo).append("/").append(entitySubTable)
					.append(".js\"/>' type=\"text/javascript\"></script>").append(Constant.SYSMBOL_LINE);

			paraDetail.setEasySearchVO(paraForm.getEasySearchVO());
			paraDetail.setAttachmentLists(paraForm.getAttachmentLists());
			//生成js文件
			String detailTableName = paraDetail.getTableName();
			paraDetail.setTableName(detailTableName.toLowerCase());

			if (buildPageJSFile == null) {
				buildPageJSFile = new BuildPageJSFile();
			}
			if (paraForm.getIsform() == 1) {  //是表单生成器
				queryUrl = "'/dataManage/slicedQueryDataRecordDetail.ajax'";
			} else {
				queryUrl = "'/dataManage/slicedQuery" + entitySubTable + "Detail.ajax";
			}
			queryUrl += "?maiTab=" + mainTableName;
			queryUrl += "&subTab=" + detailTableName;
			queryUrl += "&formId=" + "$(\"#formId\").val()";
			queryUrl += "+'&id='+" + "$(\"#id\").val()";

			StringBuffer sbjs = buildPageJSFile.generateContents(paraDetail, mainTableName, paraForm.getRealFieldEns(), true, queryUrl);
			if (paraForm.getIsform() == 1) {  //是表单生成页面
				Utils.generateFile(paraForm.getFormPath() + "/" + entitySubTable + ".js", sbjs);
			} else {   // 代码生成器
				Utils.generateFile(paraForm.getSrcPath() + "/" + entitySubTable + ".js", sbjs);

			}
		}
		sb.append(" </head> ").append(Constant.SYSMBOL_LINE);

	}

	//计算显示行数
	private int countRows(ParamFormVO paraForm) {
		//int cols = Integer.parseInt(Constant.PAGEDETAIL_COLS);//每行显示标签个数
		//String[] fieldTags = paraForm.getFieldTags();
		//String[] fieldEns = paraForm.getFieldEns();
		String[] fieldCols = paraForm.getFieldCols();
		String[] labelCosl = paraForm.getLabelCols();
		/*int areaCols = 0;
		//判断是否存在textarea标签，增加行数
		for (int y = 0; y < fieldTags.length; y++) {
			if ("textarea".equals(fieldTags[y]))
				areaCols++;
			if (y % cols != 0) //不在行的开始位置
				areaCols++;
		}
		int remainder = (fieldEns.length - areaCols) % cols; //余数
		int rows = (fieldEns.length - areaCols) / cols; //行数
		if (remainder != 0) //余数不是0
			rows++;
		rows += areaCols;
		*/
		int allCols=0;
		for (int y = 0; y < fieldCols.length; y++) {
			allCols+=Integer.parseInt(fieldCols[y])+Integer.parseInt(labelCosl[y]);
		}
		int rows=allCols/Constant.TAG_MAXCOLS;
     	if (allCols%Constant.TAG_MAXCOLS!=0){
     		rows++;
		}
		return rows;
	}

	//**获取页面标签类型
	private FieldTagTypeInter getFieldTagType(String condition) {
		FieldTagTypeInter inter = null;
		switch (condition) {
			case Constant.TEXT_TAG:
				inter = new InputTagResult();
				break;
			case Constant.SPINNER_TAG:
				inter=new SpinnerInputTagResult();
				break;
			case Constant.SELECT_TAG:
				inter = new SelectTagResult();
				break;

			case Constant.TEXTAREA_TAG:
				inter = new TextAreaTagResult();
				break;

			case Constant.DATE_TAG:
				inter = new DateTagResult();
				break;

			case Constant.RADIOS_TAG:
				inter = new RadiosTagResult();
				break;

			case Constant.CHECKBOX_TAG:
				inter = new CheckboxTagResult();
				break;
			case Constant.FILE_TAG:
				inter = new FileTagResult();
				break;
			case Constant.DIVIDER_TAG:
				inter = new DividerResult();
				break;
			case Constant.LABEL_TAG:
				inter = new LabelTagResult();
				break;
			case Constant.HTML_TAG:
				inter = new HtmlTagResult();
				break;

			default:
		}
		return inter;
	}

	//添加带有流程的表单 获取明细表数据的Js
	private void getFlowDetailDataMethod(StringBuffer sb, List<ParamFormVO> listDetails) {
		if (listDetails.size() > 0) {
			//增加带有流程的获取数据保存的参数
			sb.append("function getExtendedData(processAction) { ");
			sb.append(Constant.SYSMBOL_LINE);
			//回退、打回、转交时，不需要验证必填项是否已经填写；
			sb.append("if (processAction == ProcessAction.BACK||processAction == ProcessAction.REPLENISH")
					.append(" ||processAction == ProcessAction.TRANSMIT) { ");
			//不验证
			sb.append("	$('#submitForm').attr('check', false); 	} ");
			sb.append("const isAllData = $('#oldId') || !getId();");
			sb.append("var extendedData = {};");
			String entitySubTable = "";
			for (ParamFormVO paramFormVO : listDetails) {
				entitySubTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramFormVO.getTableName());
				sb.append("var detailData = DataUtil.getGridData({ ");
				sb.append("		isAllData : true,");
				sb.append("		gridManager :").append(entitySubTable).append("GridManager");
				sb.append("		});");
				sb.append(" if(detailData && detailData instanceof Array && detailData.length >0){");
				sb.append("	if (!detailData) {");
				sb.append("		return false;");
				sb.append("	} ");

				sb.append("extendedData.").append(entitySubTable).append("data=Public.encodeJSONURI(detailData);");
				sb.append("	}");
			}
			sb.append(" return extendedData;");
			sb.append(Constant.SYSMBOL_LINE);
			sb.append("}");
			sb.append(Constant.SYSMBOL_LINE);
		}
	}

	//含有流程 保存后的回调方法
	private void getFlowAfterSaveMethod(StringBuffer sb, List<ParamFormVO> listDetails, ParamFormVO paramForm) {
		if (listDetails.size() > 0) {
			sb.append("function afterSave(bizData) {");
			sb.append(Constant.SYSMBOL_LINE);
			//sb.append("		var mid=getId(); ");
			sb.append("	var params=[];");
			String entitySubTable = "";
			for (ParamFormVO paramFormVO : listDetails) {
				entitySubTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramFormVO.getTableName());
				sb.append(entitySubTable).append("GridManager.options.url=web_app.name + '/dataManage/slicedQueryDataRecordDetail.ajax?id='+getId();");
				//sb.append(btnAttr.getEntityName()).append("GridManager.isDataChanged=flase;");  //但是页面有提示？
				//sb.append("UICtrl.gridSearch(").append(btnAttr.getEntityName()).append("GridManager, params);");
				sb.append(entitySubTable).append("GridManager.loadData();");
			}
			if (paramForm.getAttachmentLists().size()>0) {
				List<FormAttachVO> attachLists = paramForm.getAttachmentLists();
				for (FormAttachVO attachVO : attachLists) {
					//sb.append(" if ($('#").append(btnAttr.getParentEntityName()).append("Attach'))	{ $('#")
					//		.append(btnAttr.getParentEntityName()).append("Attach').fileList({bizId:getId()});  }");
					sb.append(" if ($('#").append(attachVO.getFileId()).append("Attach'))	{ $('#")
							.append(attachVO.getFileId()).append("Attach').fileList({bizId:getId()});  }");
				}
			}
			sb.append(Constant.SYSMBOL_LINE);
			sb.append("}");
			sb.append(Constant.SYSMBOL_LINE);
		}
	}

	//含有流程 保存前的回调方法
	private void getFlowBeforeSaveMethod(StringBuffer sb, List<ParamFormVO> listDetails, ParamFormVO paramForm) {
		if (listDetails.size() > 0) {
			sb.append("function beforeSave() { ");
			sb.append("}");
			sb.append(Constant.SYSMBOL_LINE);
		}
	}

	// 带有明细表,而且表单带有流程 ，需要重新实现 保存主表的方法
	private void getSaveMainEntityMethod(StringBuffer sb, List<ParamFormVO> listDetails,ParamFormVO paramForm) {
		if (listDetails.size() > 0) {
			String entityMainTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramForm.getTableName());
			sb.append("function doSave").append(Utils.toUpperCaseFirstOne(entityMainTable)).append("ByDetail(grid){");
			sb.append(Constant.SYSMBOL_LINE);
			sb.append(" var _self = this;");
			sb.append("   var id = getId();");

			sb.append("  if ($('#procId').val()!=\"\") { ");
			//sb.append("   UICtrl.addGridRow(").append(btnAttr.getEntityName()).append("GridManager,{id:''} );");
			sb.append("   UICtrl.addGridRow(eval(grid),{id:''} );");
			sb.append(" } else { ");

			if (paramForm.getIsform() == 1) {  //是表单生成器 则调用统一的添加方法
				sb.append("  var url= '/dataManage/saveDataRecord.ajax';");
				sb.append("  if (grid==1) { url+='?btntype=1';  } ");
				sb.append("  $('#submitForm').ajaxSubmit({");   //发起流程 必须固定表单名称为submitForm
			} else {
				sb.append("   var url = '/").append(Utils.toLowerCaseFirstOne(entityMainTable))
						.append("/save").append(Utils.toUpperCaseFirstOne(entityMainTable)).append(".ajax';");
				// sb.append("  $('#").append(Utils.toLowerCaseFirstOne(btnAttr.getEntityName())).append("Form').ajaxSubmit({");
				sb.append("  $('#submitForm').ajaxSubmit({");
			}

			sb.append("       url: web_app.name +url,");
			sb.append("       success: function (data) {");

			sb.append("           $(\"#id\").val(data);");
			//sb.append("         if ($('#").append(btnAttr.getParentEntityName()).append("'))	{ $('#");
			//sb.append(btnAttr.getParentEntityName()).append("Attach').fileList({bizId:data});  } ");
			if (paramForm.getAttachmentLists().size()>0) {
				List<FormAttachVO> attachLists = paramForm.getAttachmentLists();
				for (FormAttachVO attachVO : attachLists) {
					sb.append("   $('#").append(attachVO.getFileId()).append("Attach').fileList({bizId:data});");
				}
			}
			sb.append("           if (grid&&grid!=\"\"&&grid!=1) {UICtrl.addGridRow(eval(grid),{id:''}  );}");
			//sb.append("      	  reload").append(Utils.toUpperCaseFirstOne(btnAttr.getEntityName())).append("Grid();");
			//sb.append("       	  refreshFlag = true;");
			//sb.append("           _self.close();");
			sb.append("      }");
			sb.append("   });");

			sb.append(" }");
			sb.append(Constant.SYSMBOL_LINE);
			sb.append(" } ");
			sb.append(Constant.SYSMBOL_LINE);
		}
	}
	//增加 带流程的表单以Tab页面打开新增页面, 增加主表中的初始化新增方法
	private void getInitAddMainMethod(StringBuffer sb, List<ParamFormVO> listDetails,ParamFormVO paraForm) {
		if (listDetails.size() > 0) {
			String entityMainTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paraForm.getTableName());
			sb.append(" function initAdd").append(Utils.toUpperCaseFirstOne(entityMainTable)).append("(){");
			sb.append(Constant.SYSMBOL_LINE);
			ButtonAttributeVO btnAttr = new ButtonAttributeVO();
			btnAttr.setIsForm(paraForm.getIsform());
			btnAttr.setEntityName(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paraForm.getTableName()));
			ClassHelper.copyProperties(paraForm.getEasySearchVO(), btnAttr);
			//btnAttr.setExistAttachment(paraForm.getExistAttachment());
			btnAttr.setAttachmentLists(paraForm.getAttachmentLists());

			Utils.createEasySearch(sb, btnAttr);

			if (paraForm.getAttachmentLists().size()>0) {

				List<FormAttachVO> attachLists = paraForm.getAttachmentLists();
				for (FormAttachVO attachVO : attachLists) {
					sb.append("   $('#").append(attachVO.getFileId()).append("Attach').fileList({bizId:$(\"#attbizid\").val()});");
					// sb.append("   var _attbizid=$(\"#attbizid\").val();");
					//sb.append("   $('#").append(Utils.toLowerCaseFirstOne(mainEntityName)).append("Attach').fileList({bizId:_attbizid}); ");
				}
				   //String  fieldTags[]=paraForm.getFieldTags();
			}
			sb.append(Constant.SYSMBOL_LINE);
			sb.append("}");
			sb.append(Constant.SYSMBOL_LINE);
		}
	}
      //页签的布局
	  private void getTabsLayout(StringBuffer sb, List<ParamFormVO> listDetails,ParamFormVO paraForm){
		if (paraForm.getTabLabels()!=null&&paraForm.getTabLabels().size()>0) {
			List <String> tabLists=paraForm.getTabLabels();
			for (String tabs:tabLists) {   //遍历多个tabs
				sb.append("<div id = \"tabPage\"> ");
				sb.append(" <div class=\"tabPanel\"> ");
				sb.append("	<ul>");
				int u = 0;
				for (ParamFormVO paramFormDetail : listDetails) {
					if (paramFormDetail.getTabLabels().size() > 0 && paramFormDetail.getTabLabels().get(0).indexOf(tabs) > -1) {
						String entityMainTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramFormDetail.getTableName());
						sb.append("<li ");
						if (u == 0) {
							sb.append(" class=\"hit\"");
						//			" divid =\"dli_").append(entityMainTable).append("\" ><c:out value =\"");
						//	sb.append(paramFormDetail.getTabLabels().get(0).split(Constant.TAB_SEPARATE)[1]);
						//	sb.append("\"/></li >");
						}
							sb.append(" divid =\"dli_").append(entityMainTable).append("\" ><c:out value =\"");
							sb.append(paramFormDetail.getTabLabels().get(0).split(Constant.TAB_SEPARATE)[1]);
							sb.append("\"/></li >");
						u++;
					}
				}
				sb.append("</ul>");
				sb.append(" <div class=\"panes\">");
				  u=0;
				for (ParamFormVO paramFormDetail : listDetails) {
					if (paramFormDetail.getTabLabels().size() > 0 && paramFormDetail.getTabLabels().get(0).indexOf(tabs) >-1) {
						String entityMainTable = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, paramFormDetail.getTableName());
						 sb.append("  <div class=\"pane\"");
						if (u == 0) {
							sb.append("  style = \"display:block;\" >");
						} else {
							sb.append(">");
						}
							sb.append(" 	<div class=\"layout\" >");
							sb.append("		<div id = \"").append(entityMainTable).append("Grid\" style = \"margin: 0px;overflow:hidden\" >");
                            if ("grid".equals(paramFormDetail.getDisplayMode())){  //明细表 使用标签展示？
                                paramFormDetail.setIsform(0);
								if (paramFormDetail.getButtonDefines().size()>0){
									for (ButtonDefineVO buttonDefineVO:paramFormDetail.getButtonDefines()){
										sb.append("	<button class=\"btn btn-success\" type=\"button\" id=\"").append(buttonDefineVO.getButtonMethodName())
											.append("\" style=\"left: 200px;float:right;bottom: 10px;\">")
										.append(buttonDefineVO.getButtonName()).append("</button>");
									}
								}
                                sb.append("	<form class=\"hg-form\" method=\"post\" action=\"\" id=\"").append(entityMainTable).append("Form\">");
                                generateFieldTag(paramFormDetail,sb,0,100);
                                sb.append("</form>");
                            }
                            sb.append("</div >");
							sb.append("	</div>");
							sb.append("  </div >");
						/*} else {
							sb.append("	   <div class=\"pane\" >");
							sb.append("	 <div class=\"layout\" >");
							sb.append("	  	<div id = \"").append(entityMainTable).append("Grid\" style = \"margin: 0px;overflow:hidden\" ></div >");
                            if ("grid".equals(paramFormDetail.getDisplayMode())){
                                paramFormDetail.setIsform(0);
                                sb.append("	<form class=\"hg-form\" method=\"post\" action=\"\" id=\"").append(entityMainTable).append("Form\">");
                                generateFieldTag(paramFormDetail,sb);
                                sb.append("</form>");
                            }
							sb.append(" 	 </div >");
							sb.append("  </div >");*/
						//}
						u++;
					}
				}


				sb.append("   </div>");
				sb.append("   </div>");
				sb.append("  </div>  ");
/*
		   			<li class="hit" divid = "dli_dictionary" ><c:out value = "数据字典" / ></li >
		   			<li divid = "dli_coderule" ><c:out value = "编码规则" / ></li >
					<li divid = "dli_formprompt" ><c:out value = "表单提示" / ></li >
					<li divid = "dli_easysearch" ><c:out value = "检索SQL" / ></li >
					<li divid = "dli_checkfunction" ><c:out value = "校验函数" / ></li >
					<li divid = "dli_procduce" ><c:out value = "存储过程" / ></li >

			sb.append("</ul>\");
			   <div class="panes" >
				   <div class="pane" style = "display:block;" >
				   	<div class="layout" >
				   		<div id = "dli_dictionary" style = "margin: 0px;overflow:hidden" ></div >
				   	</div >
				   </div >
				   <div class="pane" >
				   	 <div class="layout" >
				   	  	<div id = "dli_coderule" style = "margin: 0px;overflow:hidden" ></div >
				   	 </div >
				   </div >



			   </div >
		   </div >
     </div >   */
			}
		}
	}
}
