package com.huigou.uasp.builder;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.vo.ParamFormVO;
import com.huigou.uasp.util.Constant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import java.util.List;
import java.util.Map;

public class BuildCommon {

    protected boolean allowEdit=false; //列表允许编辑
    protected boolean doubleClick=true; //列表允许行双击
   // protected boolean allowNewLine=true; //代码允许换行

    @Autowired
    protected ApplicationContext applicationContext;


    protected StringBuffer addNewLineSymbol(StringBuffer sb,boolean allowNewLine) {
        String result = sb.toString();
        if (allowNewLine) {
            result = result.replace("{", "{" + Constant.SYSMBOL_LINE);
            result = result.replace("}", "}" + Constant.SYSMBOL_LINE);
            result = result.replace(";", ";" + Constant.SYSMBOL_LINE);
            result = result.replace("={" + Constant.SYSMBOL_LINE, "={"); //去掉换行符
            result = result.replace("}" + Constant.SYSMBOL_LINE + ";" + Constant.SYSMBOL_LINE, "};" + Constant.SYSMBOL_LINE);
            result = result.replace("{" + Constant.SYSMBOL_LINE + "display:", "{display:"); //列表显示去掉换行符
            sb=new StringBuffer(result);
        }
        return sb;
    }
     //下划线转成驼峰法
    protected String toHumpOfCamel(String str) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, str);
    }
    //驼峰法转下划线
    protected String toUnderline(String str) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE,str);
    }
}
