package com.huigou.explorer.util;

import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author yonghuan
 */
public final class MxCellUtils {

    public static Optional<Shape> parseShape(mxCell cell) {
        String style = cell.getStyle();
        if (StringUtils.isBlank(style)) {
            return Optional.empty();
        }
        return Arrays.stream(style.split(";"))
                .map(str -> str.split("="))
                .filter(ss -> "shape".equals(ss[0]))
                .map(ss -> ss[1])
                .map(Shape::of)
                .filter(Optional::isPresent)
                .map(Optional::get)
                .findAny();
    }

}
