package com.huigou.explorer.converters.mxgraph;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.*;

/**
 * <pre>
 *      <object code="start" label="开始" id="37">
 *             <mxCell style="shape=workflow.start_events.general_start;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2"
 *                     vertex="1" parent="1">
 *                 <mxGeometry x="362" y="20" width="45" height="45" as="geometry"/>
 *             </mxCell>
 *         </object>
 * </pre>
 *
 * @author yonghuan
 */
public class MxStartEventConverter extends AbstractMxVertexConverter implements MxElementConverter {

    private final static String VERTEX_STYLE = "shape=workflow.start_events.general_start;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2";

    @Override
    public boolean supports(BaseElement baseElement) {
        return baseElement instanceof StartEvent;
    }

    @Override
    protected void convertInternal(BpmnModel bpmnModel, Process process, mxGraph graph, FlowElement fe, mxCell vertex) {
        vertex.setStyle(VERTEX_STYLE);
    }
}
