package com.huigou.explorer.converters.mxgraph;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.*;
import org.activiti.bpmn.model.Process;

/**
 * <pre>
 *      <object code="end" label="结束" id="38">
 *             <mxCell style="shape=workflow.end_events.end_event;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2"
 *                     vertex="1" parent="1">
 *                 <mxGeometry x="361" y="578" width="48" height="48" as="geometry"/>
 *             </mxCell>
 *         </object>
 * </pre>
 *
 * @author yonghuan
 */
public class MxEndEventConverter extends AbstractMxVertexConverter implements MxElementConverter {

    private final static String VERTEX_STYLE_PATTERN = "shape=workflow.end_events.%s;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2";

    @Override
    public boolean supports(BaseElement baseElement) {
        return baseElement instanceof EndEvent;
    }

    @Override
    protected void convertInternal(BpmnModel bpmnModel, Process process, mxGraph graph, FlowElement fe, mxCell vertex) {
        vertex.setStyle(String.format(VERTEX_STYLE_PATTERN, camelCaseToUnderscoreCase(fe.getClass().getSimpleName())));
    }
}
