package com.huigou.explorer.converters.bpmn;

import com.alibaba.fastjson.JSONArray;
import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CustomProperty;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yonghuan
 */
public class UserTaskConverter extends AbstractElementConverter implements ElementConverter {

    public final static String CUSTOM_PROPERTY_NEED_TIMING = "needTiming";
    public final static String CUSTOM_PROPERTY_LIMIT_TIME = "limitTime";
    public final static String CUSTOM_PROPERTY_PREVIEW_HANDLER = "previewHandler";
    public final static String CUSTOM_PROPERTY_ASSISTANT_MUST_APPROVE = "assistantMustApprove";
    public final static String CUSTOM_PROPERTY_MERGE_HANDLER_KIND = "mergeHandlerKind";
    /**
     * 用户任务描述表达式
     */
    public final static String CUSTOM_PROPERTY_USER_TASK_DESCRIPTION_EXPRESSION = "descriptionExpression";
    public final static List<String> CUSTOM_PROPERTIES = Arrays.asList(CUSTOM_PROPERTY_NEED_TIMING, CUSTOM_PROPERTY_LIMIT_TIME, CUSTOM_PROPERTY_PREVIEW_HANDLER, CUSTOM_PROPERTY_ASSISTANT_MUST_APPROVE, CUSTOM_PROPERTY_MERGE_HANDLER_KIND, CUSTOM_PROPERTY_USER_TASK_DESCRIPTION_EXPRESSION);

    public UserTaskConverter() {
        super(Collections.singletonList(Shape.USER_TASK));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        UserTask userTask = new UserTask();
        userTask.setFormKey(cell.getAttribute("formKey"));
        userTask.setAssignee(cell.getAttribute("assignee"));
        userTask.setSkipExpression(cell.getAttribute("skipExpression"));
        userTask.setDueDate(cell.getAttribute("dueDate"));
        userTask.setCategory(cell.getAttribute("category"));
        Optional.ofNullable(cell.getAttribute("candidateUsers"))
                .filter(StringUtils::isNotBlank)
                .map(candidateUsers -> candidateUsers.split(","))
                .map(Arrays::asList)
                .ifPresent(userTask::setCandidateUsers);
        Optional.ofNullable(cell.getAttribute("candidateGroups"))
                .filter(StringUtils::isNotBlank)
                .map(candidateGroups -> candidateGroups.split(","))
                .map(Arrays::asList)
                .ifPresent(userTask::setCandidateGroups);
        Optional.ofNullable(cell.getAttribute("taskListeners"))
                .filter(StringUtils::isNotBlank)
                .map(JSONArray::parseArray)
                .map(getActivitiListenerParser()::parse)
                .ifPresent(userTask::setTaskListeners);

        List<CustomProperty> customProperties = CUSTOM_PROPERTIES
                .stream()
                .map(customPropertyName -> mapToCustomProperty(customPropertyName, cell))
                .collect(Collectors.toList());
        userTask.setCustomProperties(customProperties);
        return userTask;
    }

    private CustomProperty mapToCustomProperty(String customPropertyName, mxCell cell) {
        CustomProperty customProperty = new CustomProperty();
        customProperty.setName(customPropertyName);
        customProperty.setSimpleValue(cell.getAttribute(customPropertyName));
        return customProperty;
    }
}
