package com.huigou.explorer.converters.bpmn;

import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;

import java.util.Collections;

/**
 * @author yonghuan
 */
public class StartEventConverter extends AbstractElementConverter implements ElementConverter {

    public StartEventConverter() {
        super(Collections.singletonList(Shape.START_EVENT));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        StartEvent startEvent = new StartEvent();
        startEvent.setFormKey(cell.getAttribute("formKey"));
        return startEvent;
    }
}
