package com.huigou.explorer.converters.bpmn;

import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ServiceTask;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;

/**
 * @author yonghuan
 */
public class ServiceTaskConverter extends AbstractElementConverter implements ElementConverter {

    public ServiceTaskConverter() {
        super(Collections.singletonList(Shape.SERVICE_TASK));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        ServiceTask serviceTask = new ServiceTask();
        String javaClass = cell.getAttribute("javaClass");
        if(StringUtils.isNotBlank(javaClass)) {
            serviceTask.setImplementationType("class");
            serviceTask.setImplementation(javaClass);
        }
        String expression = cell.getAttribute("expression");
        if(StringUtils.isNotBlank(expression)) {
            serviceTask.setImplementationType("expression");
            serviceTask.setImplementation(expression);
        }
        String delegateExpression = cell.getAttribute("delegateExpression");
        if(StringUtils.isNotBlank(delegateExpression)) {
            serviceTask.setImplementationType("delegateExpression");
            serviceTask.setImplementation(delegateExpression);
        }
        serviceTask.setResultVariableName(cell.getAttribute("resultVariableName"));
        return serviceTask;
    }
}
