package com.huigou.explorer.converters.bpmn;

import com.huigou.explorer.Shape;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ScriptTask;

import java.util.Collections;

/**
 * @author yonghuan
 */
public class ScriptTaskConverter extends AbstractElementConverter implements ElementConverter {

    public ScriptTaskConverter() {
        super(Collections.singletonList(Shape.SCRIPT_TASK));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        ScriptTask scriptTask = new ScriptTask();
        scriptTask.setScriptFormat(cell.getAttribute("scriptFormat"));
        scriptTask.setScript(cell.getAttribute("script"));
        scriptTask.setResultVariable(cell.getAttribute("resultVariable"));
        return scriptTask;
    }
}
