package com.huigou.explorer.converters.bpmn;

import com.huigou.explorer.Shape;
import com.huigou.explorer.util.MxCellUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Gateway;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

import static com.huigou.explorer.Shape.*;

/**
 * @author yonghuan
 */
public class GatewayConverter extends AbstractElementConverter implements ElementConverter {

    public GatewayConverter() {
        super(Arrays.asList(EXCLUSIVE_GATEWAY, INCLUSIVE_GATEWAY, PARALLEL_GATEWAY, EVENT_GATEWAY));
    }

    @Override
    protected FlowElement convertInternal(BpmnModel bpmnModel, mxGraphModel graphModel, mxCell cell) {
        Shape shape = MxCellUtils.parseShape(cell).get();
        Gateway gateway;
        try {
            gateway = (Gateway) shape.modelClass.newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        String defaultFlow = cell.getAttribute("defaultFlow");
        if (StringUtils.isNotBlank(defaultFlow)) {
            gateway.setDefaultFlow(defaultFlow);
        }
        return gateway;
    }

}
