package com.huigou.explorer.converters;

import org.activiti.bpmn.model.BpmnModel;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/**
 * mxgraph XML与activiti bpmnModel相互转换的转换器。
 *
 * @author yonghuan
 */
public interface WorkflowModeConverter {

    /**
     * 将mxgraph XML转换成activiti bpmnModel。
     *
     * @param mxgraphXml      mxgraph XML
     * @param charset 字符集
     * @return activiti bpmnModel
     * @throws IOException 如果转换过程中出错就抛出该异常。
     */
    BpmnModel convertToBpmnModel(byte[] mxgraphXml, Charset charset) throws IOException;

    /**
     * 将activiti bpmnModel转换成 mxgraph XML。
     *
     * @param bpmnModel activiti bpmnModel
     * @param charset   字符集
     * @return mxgraph XML
     */
    byte[] convertToXML(BpmnModel bpmnModel, Charset charset);

}
