package com.huigou.demo.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.demo.application.LeaveApplication;
import com.huigou.demo.domain.model.Leave;
import com.huigou.demo.domain.query.LeaveQuery;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

/**
 * @author yonghuan
 */
@ControllerMapping("/leave")
@Controller
public class LeaveController extends CommonController {

    private Logger LOG = LoggerFactory.getLogger(LeaveController.class);
    @Autowired
    private LeaveApplication leaveApplication;

    @Override
    protected String getPagePath() {
        return "/biz/demo/";
    }

    /**
     * 跳转到新增请假申请页面
     */
    public String showInsertLeave() throws Exception {
        this.putAttribute("processDefinitionKey", LeaveApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        Leave leave = new Leave();
        leave.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        leave.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("leaveDetails", leave);
    }


    /**
     * 跳转到请假申请详情页面
     */
    public String showLeave() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        Leave leave = leaveApplication.loadLeaveById(id);
        return forward("leaveDetails", leave);
    }

    /**
     * 请假申请列表页面。
     */
    public String showLeaveList() {
        return forward("leaveList");
    }

    /**
     * 分页查询请假信息
     */
    public String slicedQueryMyLeave() {
        LeaveQuery query = getSDO().toQueryRequest(LeaveQuery.class);
        return toResult(leaveApplication.slicedQuery(query));
    }

}
