package com.huigou.data.domain.listener;

import com.huigou.data.domain.model.Creator;
import com.huigou.data.domain.model.Modifier;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.util.ReflectionUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.lang.reflect.Field;

@Configurable
public class CreatorAndModifierListener {

    private static String CREATOR_FIELD_NAME = "creator";

    private static String MODIFIER_FIELD_NAME = "modifier";

    private void setCreatorInfo(Object target) {
        Field field = ReflectionUtils.findField(target.getClass(), CREATOR_FIELD_NAME);
        if (field != null) {
            field.setAccessible(true);
            ReflectionUtils.setField(field, target, Creator.newInstance());
        }
    }

    private void setModifierInfo(Object target) {
        Field field = ReflectionUtils.findField(target.getClass(), MODIFIER_FIELD_NAME);
        if (field != null) {
            field.setAccessible(true);
            ReflectionUtils.setField(field, target, Modifier.newInstance());
        }
    }

    @PrePersist
    public void beforeCreate(Object target) {
        setCreatorInfo(target);
        setModifierInfo(target);
    }

    @PreUpdate
    public void beforeUpdate(Object target) {
        setModifierInfo(target);
    }

}
