package com.huigou.uasp.bpm.managment.domain.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.huigou.data.domain.model.TreeEntity;
import lombok.Getter;
import lombok.Setter;

/**
 * 流程定义
 *
 * @author gongmm
 */
@Getter
@Setter
@Entity
@Table(name = "WF_ProcDef")
public class ProcDefinition extends TreeEntity {

    public static String ROOT_ID = "1";

    private static final long serialVersionUID = 7149413572469994406L;

    @Column(name = "proc_id")
    private String procId;

    @Column(name = "proc_Name")
    private String procName;

    /**
     * 描述
     */
    private String description;

    /**
     * 审批规则流程ID
     */
    @Column(name = "approval_bridge_proc_Id")
    private String approvalBridgeProcId;

    /**
     * 节点类型
     */
    @Column(name = "node_kind_id")
    private String nodeKindId;

    /**
     * 是否计时
     */
    @Column(name = "need_Timing")
    private Integer needTiming;

    /**
     * 限制时间
     */
    @Column(name = "limit_time")
    private Integer limitTime;

    /**
     * 预览处理人
     */
    @Column(name = "show_query_handlers")
    private Integer previewHandler;

    /**
     * 协审必须审批
     */
    @Column(name = "assistant_must_approve")
    private Integer assistantMustApprove;

    /**
     * 处理人合并类型
     */
    @Column(name = "merge_handler_kind")
    private Integer mergeHandlerKind;
    /**
     * 表单编码
     */
    @Column(name = "form_no")
    private String formNo;

    public ProcDefinition(){
    }

    public ProcDefinition(String code, Integer sequence) {
        this.setCode(code);
        this.setSequence(sequence);
    }

}
