package com.huigou.uasp.bmp.opm.repository.managment;

import com.huigou.uasp.bmp.opm.domain.model.management.BizManagement;
import com.huigou.uasp.bmp.opm.domain.model.management.BizManagementType;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;

public interface BizManagementRepository extends JpaRepository<BizManagement, String>, JpaSpecificationExecutor<BizManagement> {

    List<BizManagement> findByManagerInAndBizManagementTypeAndSubordinationIn(Collection<Org> managers, BizManagementType bizManagementType,
                                                                              Collection<Org> subordinations);

    @Query("from BizManagement bm where bm.manager.id=:managerId and exists (select 1 from Org o where o.id=bm.subordination.id)")
    List<BizManagement> findByManagerId(@Param("managerId") String managerId);

}
