package com.huigou.uasp.bmp.opm.domain.model.management;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;
import com.huigou.data.domain.model.Modifier;
import com.huigou.uasp.bmp.opm.domain.model.access.Role;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;

import javax.persistence.*;

/**
 * 角色业务管理权限，角色作为管理者。
 *
 * @author yonghuan
 */
@Table(name = "SA_OPRoleBizManagement")
@Entity
@EntityListeners({CreatorAndModifierListener.class})
public class RoleBizManagement extends AbstractEntity {

    /**
     * 管理者
     */
    @ManyToOne
    @JoinColumn(name = "manager_id")
    private Role manager;
    /**
     * 业务管理权限类别
     */
    @ManyToOne
    @JoinColumn(name = "manage_type_id")
    private BizManagementType bizManagementType;
    /**
     * 下属
     */
    @ManyToOne
    @JoinColumn(name = "subordination_id")
    private Org subordination;
    /**
     * 创建者和修改者
     */
    @Embedded
    private Creator creator;

    @Embedded
    private Modifier modifier;

    public Role getManager() {
        return manager;
    }

    public void setManager(Role manager) {
        this.manager = manager;
    }

    public BizManagementType getBizManagementType() {
        return bizManagementType;
    }

    public void setBizManagementType(BizManagementType bizManagementType) {
        this.bizManagementType = bizManagementType;
    }

    public Org getSubordination() {
        return subordination;
    }

    public void setSubordination(Org subordination) {
        this.subordination = subordination;
    }

    public Creator getCreator() {
        return creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    public Modifier getModifier() {
        return modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }
}
