package com.huigou.context;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 三员安全保密管理配置
 * <p>
 * Three member security and privacy management
 *
 * @author gongmm
 */
public class TmspmConifg {

    /**
     * 是否使用三员安全管理
     */
    private boolean useTspm;

    /**
     * 是否启用三员安全管理
     */
    private boolean enableTspm;

    /**
     * 是否隐藏超级管理角色和超级管理员
     */
    private boolean doHideSuperAdministrator = false;

    private Map<String, List<String>> logAuthorities = Collections.emptyMap();

    public boolean isUseTspm() {
        return useTspm;
    }

    public void setUseTspm(boolean useTspm) {
        this.useTspm = useTspm;
    }

    public boolean isEnableTspm() {
        return enableTspm;
    }

    public void setEnableTspm(boolean enableTspm) {
        this.enableTspm = enableTspm;
    }

    public boolean isDoHideSuperAdministrator() {
        return doHideSuperAdministrator;
    }

    public void setDoHideSuperAdministrator(boolean doHideSuperAdministrator) {
        this.doHideSuperAdministrator = doHideSuperAdministrator;
    }

    public void setLogAuthorities(String logAuthorities) {
        logAuthorities = StringUtils.trimToEmpty(logAuthorities);
        this.logAuthorities = Arrays.asList(logAuthorities.split("\n"))
                .stream()
                .map(str -> str.split("[=,]"))
                .collect(Collectors.toMap(str -> StringUtils.trimToEmpty(str[0]), str ->
                        Arrays.stream(str)
                                .skip(1)
                                .map(StringUtils::trimToEmpty)
                                .filter(StringUtils::isNotBlank)
                                .collect(Collectors.toList()))
                );
    }

    public Map<String, List<String>> getLogAuthorities() {
        return logAuthorities;
    }
}
