package com.huigou.bpm.management.translate;

import com.huigou.bpm.management.domain.model.ProcessDefinition;
import org.springframework.util.Assert;

import java.io.InputStream;
import java.util.List;

/**
 * @author yonghuan
 */
public class ActivitiXmlTranslatorComposition implements ActivitiXmlTranslator {

    private List<ActivitiXmlTranslator> translators;

    public ActivitiXmlTranslatorComposition(List<ActivitiXmlTranslator> translators) {
        Assert.notEmpty(translators, "translators 不能为空");
        for (ActivitiXmlTranslator translator : translators) {
            Assert.notNull(translator, "translator 不能为空");
        }
        this.translators = translators;
    }

    @Override
    public boolean supports(ProcessDefinition definition) {
        return translators.stream()
                .anyMatch(translator -> translator.supports(definition));
    }

    @Override
    public InputStream translate(ProcessDefinition definition) {
        return translators.stream()
                .filter(translator -> translator.supports(definition))
                .map(translator -> translator.translate(definition))
                .findFirst()
                .orElseThrow(() -> new UnsupportedOperationException("未找到匹配的 ActivitiXmlTranslator"));
    }
}
