package com.huigou.bpm.management.translate;


import com.huigou.bpm.management.domain.model.ProcessDefinition;

import java.io.InputStream;

/**
 * Activiti XML 流程定义翻译器。
 * 用于将平台流程定义的XML文件转换为Activiti规范的流程定义XML文件。
 *
 * @author yonghuan
 */
public interface ActivitiXmlTranslator {

    /**
     * 判断是否能够进行转换。
     *
     * @param definition 平台流程定义
     * @return 如果能够进行转换就返回true, 否则返回fasle
     */
    boolean supports(ProcessDefinition definition);

    /**
     * 将平台流程定义转换成Activiti规范的流程定义XML文件
     *
     * @param definition 平台BPM流程定义
     * @return activiti规范的流程定义XML文件
     */
    InputStream translate(ProcessDefinition definition);

}
