package com.huigou.bpm.management.repository;

import com.huigou.bpm.management.domain.model.ServiceParam;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author yonghuan
 */
public interface ServiceParamRepository extends JpaRepository<ServiceParam, String> {

    ServiceParam findByServiceIdAndCode(String serviceId, String code);

    /**
     * 获取服务的常量列表。
     *
     * @param serviceId 服务id
     * @return 服务的常量列表
     */
    @Query("select p from ServiceParam p where p.serviceId=?1 and p.constantValue is not null")
    List<ServiceParam> findConstantsByServiceId(String serviceId);
}
