package com.huigou.bpm.management.repository;

import com.huigou.bpm.management.domain.model.ServiceParamMapping;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author yonghuan
 */
public interface ServiceParamMappingRepository extends JpaRepository<ServiceParamMapping, String> {

    /**
     * 删除流程节点变量绑定的服务参数。
     *
     * @param procdefId    流程定义id
     * @param activityCode 流程节点编码
     */
    @Query("delete from ServiceParamMapping where variableId in (select v.id from ProcessVariable v where v.procdefId=?1) and activityCode=?2")
    @Modifying
    void deleteAll(String procdefId, String activityCode);

    /**
     * 查询流程节点变量绑定的服务参数。
     *
     * @param procdefId    流程定义id
     * @param activityCode 流程节点编码
     * @return ServiceParamMapping
     */
    @Query("from ServiceParamMapping where variableId in (select v.id from ProcessVariable v where v.procdefId=?1) and activityCode=?2")
    List<ServiceParamMapping> findAll(String procdefId, String activityCode);

    /**
     * @param activityCode bpm流程节点编码
     * @param paramId      服务参数id
     * @param variableId   流程变量id
     */
    @Query("select count(ServiceParamMapping) from ServiceParamMapping where activityCode=?1 and paramId=?2 and variableId=?3")
    long countAll(String activityCode, String paramId, String variableId);

    @Query("from ServiceParamMapping where activityCode=?1 and paramId=?2 and variableId=?3")
    ServiceParamMapping findOne(String activityCode, String paramId, String variableId);

}
