package com.huigou.bpm.management.mapper;

import com.huigou.bpm.management.domain.bo.ServiceParamMappingBO;
import com.huigou.bpm.management.domain.query.ServiceParamMappingQueryRequest;
import com.huigou.bpm.management.domain.query.ServiceParamQueryRequest;
import com.topsunit.query.annotations.Dictionary;
import com.topsunit.query.annotations.Mapper;
import com.topsunit.query.annotations.ResultType;
import com.topsunit.query.annotations.Select;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
@Mapper(xml = "config/bpm/query/serviceParamMapper.xml")
public interface ServiceParamMapper {

    @Dictionary(field = "kindId", value = "serviceParamKind")
    Page<Map<String, Object>> sliceQuery(ServiceParamQueryRequest queryRequest);

    @ResultType(ServiceParamMappingBO.class)
    @Select
    List<ServiceParamMappingBO> sliceQuery$queryInParamMapping(ServiceParamMappingQueryRequest queryRequest);

    @ResultType(ServiceParamMappingBO.class)
    @Select
    List<ServiceParamMappingBO> sliceQuery$queryOutParamMapping(ServiceParamMappingQueryRequest queryRequest);

}
