package com.huigou.bpm.management.domain.model;

import com.huigou.data.domain.model.TreeEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 业务服务注册信息。
 *
 * @author yonghuan
 */
@Getter
@Setter
@Table(name = "tbpm_service_registration")
@Entity
public class ServiceRegistration extends TreeEntity {

    /**
     * 备注
     */
    private String remark;
    /**
     * 服务地址
     */
    private String uri;
    /**
     * 节点类型, 0 分类， 1 服务
     */
    @Column(name = "node_kind_id")
    private Integer nodeKindId;
    /**
     * 服务类型
     */
    @Column(name = "kind_id")
    private String kindId;

}
