package com.huigou.bpm.management.domain.model;

import com.huigou.data.domain.model.BaseInfoAbstractEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Arrays;

/**
 * 业务服务参数
 *
 * @author yonghuan
 */
@Getter
@Setter
@Table(name = "tbpm_service_param")
@Entity
public class ServiceParam extends BaseInfoAbstractEntity {
    /**
     * 服务注册id
     */
    @Column(name = "service_id")
    private String serviceId;
    /**
     * 参数类型，入参或出参
     *
     * @see Kind
     */
    @Column(name = "kind_id")
    private Integer kindId;
    /**
     * 常量值
     */
    @Column(name = "constant_value")
    private String constantValue;


    /**
     * 参数的类型。
     */
    public enum Kind {
        /**
         * 入参
         */
        IN(0),
        /**
         * 出参。
         */
        OUT(1),
        /**
         * 出参/入参
         */
        IN_OUT(2);
        public final int id;

        Kind(int id) {
            this.id = id;
        }

        public static Kind valueOf(int id) {
            return Arrays.stream(Kind.values())
                    .filter(k -> k.id == id)
                    .findAny().orElse(null);
        }

        public static Kind valueOf(Integer id) {
            if (id == null) {
                return null;
            }
            return valueOf(id.intValue());
        }

        /**
         * 判断是否是入参。
         *
         * @param id 类型id
         * @return 如果是入参就返回true，否则返回false
         */
        public static boolean isIn(Integer id) {
            Kind kind = valueOf(id);
            return kind != null && (kind == IN || kind == IN_OUT);
        }

        /**
         * 判断是否是出参。
         *
         * @param id 类型id
         * @return 如果是出参就返回true，否则返回false
         */
        public static boolean isOut(Integer id) {
            Kind kind = valueOf(id);
            return kind != null && (kind == OUT || kind == IN_OUT);
        }
    }
}
