package com.huigou.bpm.management.domain.model;

import com.huigou.annotation.JsonIgnore;
import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.listener.VersionListener;
import com.huigou.data.domain.model.Creator;
import com.mxgraph.io.mxCodec;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.util.mxXmlUtils;
import com.topsunit.query.annotations.Dictionary;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

import javax.persistence.*;
import java.util.Optional;

/**
 * BPM 流程定义发布信息。
 *
 * @author yonghuan
 * @since 1.1.3
 */
@Getter
@Setter
@EntityListeners({
        CreatorAndModifierListener.class,
        VersionListener.class
})
@Table(name = "tbpm_proc_deployment")
@Entity
public class ProcessDeployment {
    /**
     * id格式为:  流程定义code:发布版本号:流程定义id
     */
    @Id
    private String id;
    /**
     * 流程定义id
     */
    @Column(name = "procdef_id")
    private String procdefId;

    /**
     * 流程图类型
     */
    @Dictionary("chartKindId")
    @Column(name = "chart_kind_id")
    private String chartKindId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 发布人， 发布时间
     */
    @Embedded
    private Creator creator;
    /**
     * 流程版本号，这个字段需要跟 Activiti 流程定义表的版本字段保持一致
     */
    @Column(name = "proc_version")
    private Integer procVersion;
    /**
     * 对应的activiti流程定义id
     */
    @Column(name = "act_procdef_id")
    private String actProcdefId;
    /**
     * 编码
     */
    private String code;
    /**
     * 名称
     */
    private String name;

    /**
     * 状态
     */
    private Integer status;
    /**
     * 实体版本号
     */
    private Long version;
    /**
     * 流程定义xml，部署流程定义的时候从流程定义中复制过来。
     */
    private String xml;
    /**
     * 流程定义的图片xml，部署流程定义的时候从流程定义中复制过来。
     */
    @Column(name = "image_xml")
    private String imageXml;
    @Column(name = "image_height")
    private Integer imageHeight;
    @Column(name = "image_width")
    private Integer imageWidth;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public Optional<mxGraphModel> getGraphModel() {
        if (StringUtils.isBlank(this.getXml())) {
            return Optional.empty();
        }
        Document doc = mxXmlUtils.parseXml(this.getXml());
        mxCodec codec = new mxCodec(doc);
        mxGraphModel graphModel = (mxGraphModel) codec.decode(doc.getDocumentElement());
        return Optional.of(graphModel);
    }
}
