package com.huigou.bpm.management.domain.model;

import com.huigou.data.domain.model.TreeEntity;
import com.topsunit.query.annotations.Dictionary;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Optional;

/**
 * BPM 流程定义。
 *
 * @author yonghuan
 * @since 1.1.3
 */
@Getter
@Setter
@Table(name = "tbpm_procdef")
@Entity
public class ProcessDefinition extends TreeEntity {

    /**
     * 流程图类型
     */
    @Dictionary("chartKindId")
    @Column(name = "chart_kind_id")
    private String chartKindId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 节点类型，0 分类， 1 流程定义
     */
    @Column(name = "node_kind_id")
    private Integer nodeKindId;
    /**
     * 流程定义xml
     */
    private String xml;
    /**
     * 流程定义的图片xml。
     */
    @Column(name = "image_xml")
    private String imageXml;
    @Column(name = "image_height")
    private Integer imageHeight;
    @Column(name = "image_width")
    private Integer imageWidth;

}
