package com.huigou.bpm.management.domain.model;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.listener.VersionListener;
import com.huigou.data.domain.model.Creator;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 流程实例。
 *
 * @author yonghuan
 */
@Getter
@Setter
@Table(name = "tbpm_proc_inst")
@EntityListeners({CreatorAndModifierListener.class, VersionListener.class})
@Entity
public class ProcInst implements Serializable {

    /**
     * 流程实例id
     */
    @Id
    private String id;
    /**
     * 实体版本号
     */
    private Long version;
    @Column(name = "proc_deploy_id")
    private String procDeployId;
    @Enumerated
    private Creator creator;
    /**
     * 流程结束时间。
     */
    @Column(name = "complete_date")
    private Date completeDate;
    /**
     * 流程实例状态
     */
    private Integer status;
    /**
     * 流程实例的名称
     */
    private String name;
    /**
     * 流程实例的描述
     */
    private String description;
    @Column(name = "biz_key")
    private String bizKey;


    public enum Status {
        /**
         * 逻辑删除。
         */
        DELETED(-1),
        /**
         * 已经启动
         */
        STARTED(1),
        /**
         * 已经完成
         */
        COMPLETED(2);

        public final int id;

        Status(int id) {
            this.id = id;
        }
    }
}
