package com.huigou.bpm.management.controller;

import com.huigou.bpm.management.application.ServiceRegistrationApplication;
import com.huigou.bpm.management.domain.model.ServiceRegistration;
import com.huigou.bpm.management.domain.query.ServiceRegistrationQueryRequest;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * @author yonghuan
 */
@ControllerMapping("/bpm/service")
@Controller
public class ServiceRegistrationController extends CommonController {

    @Autowired
    private ServiceRegistrationApplication serviceRegistrationApplication;

    public String forwardAdd(SDO sdo) {
        String parentId = sdo.getParentId();
        Assert.hasText(parentId, "分类id不能为空");
        putAttribute("parentId", parentId);
        return forward("serviceDetails");
    }

    public String add(SDO sdo) {
        ServiceRegistration serviceRegistration = sdo.toObject(ServiceRegistration.class);
        serviceRegistration.setNodeKindId(1);
        serviceRegistrationApplication.add(serviceRegistration);
        return success();
    }

    /**
     * 新增分类
     */
    public String addKind(SDO sdo) {
        ServiceRegistration serviceRegistration = sdo.toObject(ServiceRegistration.class);
        serviceRegistration.setNodeKindId(0);
        serviceRegistrationApplication.add(serviceRegistration);
        return success();
    }

    public String deleteById(SDO sdo) {
        serviceRegistrationApplication.deleteById(sdo.getId());
        return success();
    }

    public String forwardUpdate(SDO sdo) {
        String id = sdo.getId();
        Assert.hasText(id, CommonDomainConstants.ID_NOT_BLANK);
        ServiceRegistration serviceRegistration = serviceRegistrationApplication.findById(id);
        return forward("serviceDetails", serviceRegistration);
    }

    public String updateById(SDO sdo) {
        serviceRegistrationApplication.updateById(sdo.toObject(ServiceRegistration.class));
        return success();
    }

    /**
     * 修改排序号
     */
    public String updateSequence() {
        Map<String, Integer> params = this.getSDO().getStringMap("data");
        serviceRegistrationApplication.updateSequence(params);
        return success();
    }

    public String forwardList() {
        return forward("serviceList");
    }

    public String sliceQuery(ServiceRegistrationQueryRequest queryRequest) {
        return toResult(serviceRegistrationApplication.sliceQuery(queryRequest));
    }

    public String forwardKind(SDO sdo) {
        String id = sdo.getId();
        Assert.hasText(id, CommonDomainConstants.ID_NOT_BLANK);
        ServiceRegistration serviceRegistration = serviceRegistrationApplication.findById(id);
        Assert.notNull(serviceRegistration, "分类不存在");
        return forward("/common/CommonTreeDetail.jsp", serviceRegistration);
    }

    @Override
    protected String getPagePath() {
        return "/system/tbpm/service/";
    }
}
