package com.huigou.bpm.management.controller;

import com.huigou.bpm.management.application.ServiceParamApplication;
import com.huigou.bpm.management.domain.model.ServiceParam;
import com.huigou.bpm.management.domain.query.ServiceParamMappingQueryRequest;
import com.huigou.bpm.management.domain.query.ServiceParamQueryRequest;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

/**
 * 服务参数管理。
 *
 * @author yonghuan
 */
@ControllerMapping("/bpm/serviceParam")
@Controller
public class ServiceParamController extends CommonController {

    @Autowired
    private ServiceParamApplication serviceParamApplication;

    public String forwardAdd(SDO sdo) {
        return forward("paramDetails");
    }

    public String add(SDO sdo) {
        serviceParamApplication.add(sdo.toObject(ServiceParam.class));
        return success();
    }

    public String deleteById(SDO sdo) {
        serviceParamApplication.deleteById(sdo.getId());
        return success();
    }

    public String forwardUpdate(SDO sdo) {
        String id = sdo.getId();
        Assert.hasText(id, CommonDomainConstants.ID_NOT_BLANK);
        ServiceParam param = serviceParamApplication.findById(id);
        Assert.notNull(param, "服务参数不存在");
        return forward("paramDetails", param);
    }

    public String updateById(SDO sdo) {
        serviceParamApplication.updateById(sdo.toObject(ServiceParam.class));
        return success();
    }


    public String forwardList(SDO sdo) {
        String serviceId = sdo.getString("serviceId");
        Assert.hasText(serviceId, "服务id不能为空");
        putAttribute("serviceId", serviceId);
        return forward("paramList");
    }

    public String sliceQuery(ServiceParamQueryRequest queryRequest) {
        return toResult(serviceParamApplication.sliceQuery(queryRequest));
    }

    public String queryInParamMapping(ServiceParamMappingQueryRequest queryRequest) {
        return packGridDataAndResult(serviceParamApplication.findInParamMapping(queryRequest));
    }

    public String queryOutParamMapping(ServiceParamMappingQueryRequest queryRequest) {
        return packGridDataAndResult(serviceParamApplication.findOutParamMapping(queryRequest));
    }

    @Override
    protected String getPagePath() {
        return "/system/tbpm/service/";
    }
}
