package com.huigou.bpm.management.controller;

import com.huigou.bpm.management.application.ProcessVariableApplication;
import com.huigou.bpm.management.domain.model.ProcessVariable;
import com.huigou.bpm.management.domain.query.ProcessVariableQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

/**
 * 流程变量管理
 *
 * @author yonghuan
 */
@ControllerMapping("/bpm/procVar")
@Controller
public class ProcessVariableController extends CommonController {

    @Autowired
    private ProcessVariableApplication variableApplication;

    public String forwardProcVarList(SDO sdo) {
        String procdefId = sdo.getString("procdefId");
        Assert.hasText(procdefId, "流程定义id不能为空");
        putAttribute("procdefId", procdefId);
        return forward("procVarList");
    }

    public String sliceQueryProcVar(ProcessVariableQueryRequest queryRequest) {
        Page<?> page = variableApplication.sliceQuery(queryRequest);
        return toResult(page);
    }

    public String forwardAddProcVar(SDO sdo) {
        String procdefId = sdo.getString("procdefId");
        Assert.hasText(procdefId, "流程定义id不能为空");
        putAttribute("procdefId", procdefId);
        return forward("procVarDetails");
    }

    public String addProcVar(SDO sdo) {
        ProcessVariable variable = sdo.toObject(ProcessVariable.class);
        variableApplication.add(variable);
        return success();
    }

    public String forwardUpdateProcVar(SDO sdo) {
        String id = sdo.getId();
        ProcessVariable variable = variableApplication.findById(id);
        return forward("procVarDetails", variable);
    }

    public String updateById(SDO sdo) {
        ProcessVariable variable = sdo.toObject(ProcessVariable.class);
        variableApplication.updateById(variable);
        return success();
    }


    public String deleteById(SDO sdo) {
        String id = sdo.getId();
        variableApplication.deleteById(id);
        return success();
    }

    @Override
    protected String getPagePath() {
        return "/system/tbpm/procVar/";
    }
}
