package com.huigou.bpm.management.controller;

import com.huigou.bpm.management.application.ProcessDefinitionApplication;
import com.huigou.bpm.management.application.ProcessDeploymentApplication;
import com.huigou.bpm.management.domain.model.ProcessDefinition;
import com.huigou.bpm.management.domain.query.ProcessDeploymentQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;

/**
 * 流程定义发布管理。
 *
 * @author yonghuan
 */
@ControllerMapping("/bpm/processDeployment")
@Controller
public class ProcessDeploymentController extends CommonController {

    @Autowired
    private ProcessDeploymentApplication deploymentApplication;
    @Autowired
    private ProcessDefinitionApplication definitionApplication;

    /**
     * 发布流程定义。
     */
    public String deploy() {
        String procdefId = getSDO().getString("procdefId");
        deploymentApplication.deployProcessDefinition(procdefId);
        return success();
    }

    public String sliceQuery() {
        return toResult(deploymentApplication.sliceQueryByProcessDefinitionId(getSDO().toQueryRequest(ProcessDeploymentQueryRequest.class)));
    }

    public String showProcessDeployment() {
        String procdefId = getSDO().getString("procdefId");
        Assert.hasText(procdefId, "流程定义不能为空");
        ProcessDefinition definition = definitionApplication.queryById(procdefId);
        Assert.notNull(definition, "流程定义不存在");
        return forward("processDeploymentList", definition);
    }

    @Override
    protected String getPagePath() {
        return "/system/tbpm/procdef/";
    }
}
