package com.huigou.bpm.management.application.impl;

import com.huigou.bpm.management.application.ServiceRegistrationApplication;
import com.huigou.bpm.management.domain.model.ServiceRegistration;
import com.huigou.bpm.management.domain.query.ServiceRegistrationQueryRequest;
import com.huigou.bpm.management.mapper.ServiceRegistrationMapper;
import com.huigou.bpm.management.repository.ServiceRegistrationRepository;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.domain.service.CommonDomainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Map;
import java.util.Objects;

/**
 * @author yonghuan
 */
@Service
public class ServiceRegistrationApplicationImpl implements ServiceRegistrationApplication {

    private ServiceRegistrationRepository serviceRegistrationRepository;
    private CommonDomainService commonDomainService;
    private ServiceRegistrationMapper serviceRegistrationMapper;

    @Autowired
    public void setServiceRegistrationRepository(ServiceRegistrationRepository serviceRegistrationRepository) {
        this.serviceRegistrationRepository = serviceRegistrationRepository;
    }

    @Autowired
    public void setCommonDomainService(CommonDomainService commonDomainService) {
        this.commonDomainService = commonDomainService;
    }

    @Autowired
    public void setServiceRegistrationMapper(ServiceRegistrationMapper serviceRegistrationMapper) {
        this.serviceRegistrationMapper = serviceRegistrationMapper;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public ServiceRegistration add(ServiceRegistration serviceRegistration) {
        Assert.notNull(serviceRegistration.getNodeKindId(), "节点类型不能为空");
        if (Objects.equals(serviceRegistration.getNodeKindId(), 0)) {
            // 分类
            Assert.hasText(serviceRegistration.getName(), CommonDomainConstants.NAME_NOT_BLANK);
            return (ServiceRegistration) commonDomainService.saveTreeEntity(serviceRegistration, serviceRegistrationRepository, false);
        } else {
            // 服务
            // Assert.notNull(serviceRegistration.getKindId(), "服务类型不能为空");
            return (ServiceRegistration) commonDomainService.saveTreeEntity(serviceRegistration, serviceRegistrationRepository);
        }
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void deleteById(String id) {
        Assert.isTrue(serviceRegistrationRepository.countByParentId(id) == 0, String.format(CommonDomainConstants.CAN_NOT_DELETE_HAS_CHILDREN, ""));
        serviceRegistrationRepository.delete(id);
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public ServiceRegistration updateById(ServiceRegistration serviceRegistration) {
        Assert.notNull(serviceRegistration.getId(), CommonDomainConstants.ID_NOT_BLANK);
        Assert.notNull(serviceRegistration, "数据不存在");
        ServiceRegistration rowInDb = serviceRegistrationRepository.findOne(serviceRegistration.getId());
        serviceRegistration.setNodeKindId(rowInDb.getNodeKindId());
        if (Objects.equals(rowInDb.getNodeKindId(), 0)) {
            // 分类
            return (ServiceRegistration) commonDomainService.saveTreeEntity(serviceRegistration, serviceRegistrationRepository, false);
        } else {
            // 服务
           // Assert.notNull(serviceRegistration.getKindId(), "服务类型不能为空");
            return (ServiceRegistration) commonDomainService.saveTreeEntity(serviceRegistration, serviceRegistrationRepository);
        }
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void updateSequence(Map<String, Integer> idSequencePair) {
        commonDomainService.updateSequence(ServiceRegistration.class, idSequencePair);
    }

    @Override
    public ServiceRegistration findById(String id) {
        return serviceRegistrationRepository.findOne(id);
    }

    @Override
    public Page<Map<String, Object>> sliceQuery(ServiceRegistrationQueryRequest queryRequest) {
        return serviceRegistrationMapper.sliceQuery(queryRequest);
    }
}
