package com.huigou.bpm.management.application;

import com.huigou.bpm.management.domain.bo.ServiceParamMappingBO;
import com.huigou.bpm.management.domain.model.ServiceParam;
import com.huigou.bpm.management.domain.query.ServiceParamMappingQueryRequest;
import com.huigou.bpm.management.domain.query.ServiceParamQueryRequest;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
public interface ServiceParamApplication {

    ServiceParam add(ServiceParam param);

    void deleteById(String id);

    ServiceParam updateById(ServiceParam param);

    ServiceParam findById(String id);

    Page<Map<String, Object>> sliceQuery(ServiceParamQueryRequest queryRequest);

    List<ServiceParamMappingBO> findInParamMapping(ServiceParamMappingQueryRequest queryRequest);

    List<ServiceParamMappingBO> findOutParamMapping(ServiceParamMappingQueryRequest queryRequest);

    /**
     * 获取服务的常量列表。
     *
     * @param serviceId 服务id
     * @return 服务的常量列表
     */
    List<ServiceParam> findConstantsByServiceId(String serviceId);
}
