package com.huigou.bpm.management.application;

import com.huigou.bpm.management.domain.model.ProcessDeployment;
import com.huigou.bpm.management.domain.query.ProcessDeploymentQueryRequest;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * 流程定义发布服务。
 *
 * @author yonghuan
 */
public interface ProcessDeploymentApplication {

    /**
     * 发布一个流程定义。
     *
     * @param processDefinitionId 流程定义id
     * @return 流程定义发布信息
     */
    ProcessDeployment deployProcessDefinition(String processDefinitionId);

    /**
     * 分页查询流程定义的发布信息
     *
     * @param queryRequest 查询条件
     * @return 流程定义发布信息
     */
    Page<?> sliceQueryByProcessDefinitionId(ProcessDeploymentQueryRequest queryRequest);

    @Transactional(readOnly = true)
    ProcessDeployment findById(String id);


}
